/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.util.StripedCompositeReadWriteLock;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridCacheGateway<K, V> {
    private final GridCacheContext<K, V> ctx;
    private final AtomicReference<State> state = new AtomicReference<State>(State.STARTED);
    private IgniteFuture<?> reconnectFut;
    private StripedCompositeReadWriteLock rwLock = new StripedCompositeReadWriteLock(Runtime.getRuntime().availableProcessors());

    public GridCacheGateway(GridCacheContext<K, V> ctx) {
        assert (ctx != null);
        this.ctx = ctx;
    }

    public void enter() {
        if (this.ctx.deploymentEnabled()) {
            this.ctx.deploy().onEnter();
        }
        this.rwLock.readLock().lock();
        this.checkState(true, true);
    }

    private boolean checkState(boolean lock, boolean stopErr) {
        State state = this.state.get();
        if (state != State.STARTED) {
            if (lock) {
                this.rwLock.readLock().unlock();
            }
            if (state == State.STOPPED) {
                if (stopErr) {
                    throw new IllegalStateException(new CacheStoppedException(this.ctx.name()));
                }
                return false;
            }
            assert (this.reconnectFut != null);
            throw new CacheException(new IgniteClientDisconnectedException(this.reconnectFut, "Client node disconnected: " + this.ctx.igniteInstanceName()));
        }
        return true;
    }

    public boolean enterIfNotStopped() {
        this.onEnter(null);
        this.rwLock.readLock().lock();
        return this.checkState(true, false);
    }

    public boolean enterIfNotStoppedNoLock() {
        this.onEnter(null);
        return this.checkState(false, false);
    }

    public void leaveNoLock() {
        this.ctx.tm().resetContext();
        this.ctx.mvcc().contextReset();
        this.ctx.tm().leaveNearTxSystemSection();
        if (!this.ctx.shared().closed(this.ctx)) {
            CU.unwindEvicts(this.ctx);
        }
    }

    public void leave() {
        try {
            this.leaveNoLock();
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Nullable
    public CacheOperationContext enter(@Nullable CacheOperationContext opCtx) {
        try {
            GridCachePreloader preldr;
            GridCacheAdapter<K, V> cache = this.ctx.cache();
            GridCachePreloader gridCachePreloader = preldr = cache != null ? cache.preloader() : null;
            if (preldr == null) {
                throw new IllegalStateException(new CacheStoppedException(this.ctx.name()));
            }
            preldr.startFuture().get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to wait for cache preloader start [cacheName=" + this.ctx.name() + "]", e);
        }
        this.ctx.tm().enterNearTxSystemSection();
        this.onEnter(opCtx);
        Lock lock = this.rwLock.readLock();
        lock.lock();
        this.checkState(true, true);
        try {
            return this.setOperationContextPerCall(opCtx);
        }
        catch (Throwable e) {
            lock.unlock();
            throw e;
        }
    }

    @Nullable
    public CacheOperationContext enterNoLock(@Nullable CacheOperationContext opCtx) {
        this.onEnter(opCtx);
        this.checkState(false, false);
        return this.setOperationContextPerCall(opCtx);
    }

    private CacheOperationContext setOperationContextPerCall(@Nullable CacheOperationContext opCtx) {
        CacheOperationContext prev = this.ctx.operationContextPerCall();
        if (prev != null || opCtx != null) {
            this.ctx.operationContextPerCall(opCtx);
        }
        return prev;
    }

    public void leave(CacheOperationContext prev) {
        try {
            this.leaveNoLock(prev);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void leaveNoLock(CacheOperationContext prev) {
        this.ctx.tm().resetContext();
        this.ctx.mvcc().contextReset();
        CU.unwindEvicts(this.ctx);
        this.ctx.tm().leaveNearTxSystemSection();
        this.ctx.operationContextPerCall(prev);
    }

    private void onEnter(CacheOperationContext opCtx) {
        this.ctx.itHolder().checkWeakQueue();
        if (this.ctx.deploymentEnabled()) {
            this.ctx.deploy().onEnter();
        }
        if (opCtx != null) {
            this.checkAtomicOpsInTx(opCtx);
        }
    }

    public boolean isStopped() {
        return !this.checkState(false, false);
    }

    public void stopped() {
        this.state.set(State.STOPPED);
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        assert (reconnectFut != null);
        this.reconnectFut = reconnectFut;
        this.state.compareAndSet(State.STARTED, State.DISCONNECTED);
    }

    public void writeLock() {
        this.rwLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.rwLock.writeLock().unlock();
    }

    public void reconnected(boolean stopped) {
        State newState = stopped ? State.STOPPED : State.STARTED;
        this.state.compareAndSet(State.DISCONNECTED, newState);
    }

    public void onStopped() {
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.rwLock.writeLock().tryLock(200L, TimeUnit.MILLISECONDS)) {
                    U.sleep(200L);
                }
            }
            catch (InterruptedException | IgniteInterruptedCheckedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        try {
            this.state.set(State.STOPPED);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void checkAtomicOpsInTx(CacheOperationContext opCtx) throws IgniteException {
        if (this.ctx.atomic() && !opCtx.allowedAtomicOpsInTx() && this.ctx.grid().transactions().tx() != null) {
            throw new IgniteException("Transaction spans operations on atomic cache (don't use atomic cache inside transaction or set up flag by cache.allowedAtomicOpsInTx()). Since 8.9.0 atomic operations inside transactions are not allowed by default. To return the previous behaviour and to allow operations with atomic caches in transactions you can set system property IGNITE_ALLOW_ATOMIC_OPS_IN_TX to true.");
        }
    }

    private static enum State {
        STARTED,
        DISCONNECTED,
        STOPPED;

    }
}

