/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.compress.EntryCompressionStrategy;
import org.jetbrains.annotations.Nullable;

public class CacheObjectContext
implements CacheObjectValueContext {
    private final GridKernalContext kernalCtx;
    private final String cacheName;
    private AffinityKeyMapper dfltAffMapper;
    private final boolean customAffMapper;
    private final boolean cpyOnGet;
    private final boolean storeVal;
    private final boolean addDepInfo;
    private final boolean binaryEnabled;
    private volatile EntryCompressionStrategy compressionStrategy;

    public CacheObjectContext(GridKernalContext kernalCtx, String cacheName, AffinityKeyMapper dfltAffMapper, boolean customAffMapper, boolean cpyOnGet, boolean storeVal, boolean addDepInfo, boolean binaryEnabled) {
        this.kernalCtx = kernalCtx;
        this.cacheName = cacheName;
        this.dfltAffMapper = dfltAffMapper;
        this.customAffMapper = customAffMapper;
        this.cpyOnGet = cpyOnGet;
        this.storeVal = storeVal;
        this.addDepInfo = addDepInfo;
        this.binaryEnabled = binaryEnabled;
    }

    public String cacheName() {
        return this.cacheName;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public boolean copyOnGet() {
        return this.cpyOnGet;
    }

    @Override
    public boolean storeValue() {
        return this.storeVal;
    }

    public AffinityKeyMapper defaultAffMapper() {
        return this.dfltAffMapper;
    }

    public boolean customAffinityMapper() {
        return this.customAffMapper;
    }

    @Override
    public GridKernalContext kernalContext() {
        return this.kernalCtx;
    }

    @Override
    public boolean binaryEnabled() {
        return this.binaryEnabled;
    }

    void compressionStrategy(EntryCompressionStrategy compressionStrategy) {
        this.compressionStrategy = compressionStrategy;
    }

    @Override
    @Nullable
    public EntryCompressionStrategy compressionStrategy() {
        return this.compressionStrategy;
    }

    @Override
    public boolean compressKeys() {
        return this.compressionStrategy != null && this.compressionStrategy.compressKeys();
    }

    public Object unwrapBinaryIfNeeded(Object o, boolean keepBinary, boolean cpy, @Nullable ClassLoader ldr) {
        if (o == null) {
            return null;
        }
        return CacheObjectUtils.unwrapBinaryIfNeeded(this, o, keepBinary, cpy, ldr);
    }
}

