/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectAdapter;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class CacheObjectByteArrayImpl
implements CacheObject,
Externalizable {
    private static final long serialVersionUID = 0L;
    protected byte[] val;

    public CacheObjectByteArrayImpl() {
    }

    public CacheObjectByteArrayImpl(byte[] val) {
        assert (val != null);
        this.val = val;
    }

    @Override
    public void finishUnmarshal(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy) {
        return this.value(ctx, cpy, null);
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy, ClassLoader ldr) {
        if (cpy) {
            return (T)Arrays.copyOf(this.val, this.val.length);
        }
        return (T)this.val;
    }

    @Override
    public byte[] valueBytes(CacheObjectValueContext ctx) throws IgniteCheckedException {
        return this.val;
    }

    @Override
    public boolean putValue(ByteBuffer buf) throws IgniteCheckedException {
        assert (this.val != null) : "Value is not initialized";
        return this.putValue(buf, 0, CacheObjectAdapter.objectPutSize(this.val.length));
    }

    @Override
    public int putValue(long addr) throws IgniteCheckedException {
        return CacheObjectAdapter.putValue(addr, this.cacheObjectType(), this.val);
    }

    @Override
    public boolean putValue(ByteBuffer buf, int off, int len) throws IgniteCheckedException {
        assert (this.val != null) : "Value is not initialized";
        return CacheObjectAdapter.putValue(this.cacheObjectType(), buf, off, len, this.val, 0);
    }

    @Override
    public int valueBytesLength(CacheObjectContext ctx) throws IgniteCheckedException {
        return CacheObjectAdapter.objectPutSize(this.val.length);
    }

    @Override
    public byte cacheObjectType() {
        return 2;
    }

    @Override
    public boolean isPlatformType() {
        return true;
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx, boolean compress) {
        return this;
    }

    @Override
    public void prepareMarshal(CacheObjectValueContext ctx) throws IgniteCheckedException {
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.val = reader.readByteArray("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheObjectByteArrayImpl.class);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.val = U.readByteArray(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeByteArray(out, this.val);
    }

    @Override
    public short directType() {
        return 105;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    public String toString() {
        GridToStringBuilder.SensitiveDataLogging sensitiveDataLogging = S.getSensitiveDataLogging();
        if (sensitiveDataLogging == GridToStringBuilder.SensitiveDataLogging.PLAIN) {
            return "CacheObjectByteArrayImpl [arrLen=" + (this.val != null ? this.val.length : 0) + ']';
        }
        if (sensitiveDataLogging == GridToStringBuilder.SensitiveDataLogging.HASH) {
            return this.val == null ? "null" : String.valueOf(IgniteUtils.hash(this.val));
        }
        return "CacheObject";
    }
}

