/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache.reset_lost_partitions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskArg;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskResult;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CacheResetLostPartitionsTask
extends VisorOneNodeTask<CacheResetLostPartitionsTaskArg, CacheResetLostPartitionsTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<CacheResetLostPartitionsTaskArg, CacheResetLostPartitionsTaskResult> job(CacheResetLostPartitionsTaskArg arg) {
        return new CacheResetLostPartitionsJob(arg, this.debug);
    }

    private static class CacheResetLostPartitionsJob
    extends VisorJob<CacheResetLostPartitionsTaskArg, CacheResetLostPartitionsTaskResult> {
        private static final long serialVersionUID = 0L;

        public CacheResetLostPartitionsJob(@Nullable CacheResetLostPartitionsTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        public CacheResetLostPartitionsTaskResult run(CacheResetLostPartitionsTaskArg arg) throws IgniteException {
            try {
                CacheResetLostPartitionsTaskResult res = new CacheResetLostPartitionsTaskResult();
                res.setMessageMap(new HashMap<String, String>());
                if (!F.isEmpty(arg.getCaches())) {
                    HashMap<CacheGroupContext, Set> grpToCaches = new HashMap<CacheGroupContext, Set>();
                    for (String cacheName : arg.getCaches()) {
                        DynamicCacheDescriptor cacheDesc = this.ignite.context().cache().cacheDescriptor(cacheName);
                        if (cacheDesc != null) {
                            CacheGroupContext grp2 = this.ignite.context().cache().cacheGroup(cacheDesc.groupId());
                            Set cacheNames = grpToCaches.computeIfAbsent(grp2, grpCtx -> new TreeSet());
                            grp2.caches().forEach(cctx -> cacheNames.add(cctx.name()));
                            continue;
                        }
                        res.put(cacheName, String.format("Cache (name = '%s', id = %d) not found.", cacheName, CU.cacheId(cacheName)));
                    }
                    if (!F.isEmpty(grpToCaches)) {
                        List<String> cachesToResetParts = grpToCaches.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                        this.ignite.resetLostPartitions(cachesToResetParts);
                        grpToCaches.forEach((grp, names) -> {
                            String grpName = grp.cacheOrGroupName();
                            res.put(grpName, String.format("Reset LOST-partitions performed successfully. Cache group (name = '%s', id = %d), caches (%s).", grpName, grp.groupId(), names));
                        });
                    }
                }
                return res;
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(CacheResetLostPartitionsJob.class, this);
        }
    }
}

