/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.cache.query.SqlBuilderContext;
import org.apache.ignite.internal.cache.query.SqlIndexQueryCriterion;
import org.apache.ignite.internal.util.typedef.internal.SB;

public final class InIndexQueryCriterion
implements SqlIndexQueryCriterion {
    private static final long serialVersionUID = 0L;
    private final String field;
    private final Set<Object> vals;

    public InIndexQueryCriterion(String field, Collection<?> vals) {
        this.field = field;
        this.vals = Collections.unmodifiableSet(new HashSet(vals));
    }

    public Set<Object> values() {
        return this.vals;
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public String toSql(SqlBuilderContext ctx) {
        if (this.vals.isEmpty()) {
            throw new IllegalArgumentException("Unsupported criterion [criterion=" + this + ']');
        }
        SqlBuilderContext.ColumnDescriptor column = ctx.resolveColumn(this.field);
        String columnName = column.name();
        boolean hasNull = this.vals.contains(null);
        if (!hasNull) {
            return this.buildInStatement(columnName, ctx);
        }
        if (this.vals.size() == 1) {
            return column.nullable() ? columnName + " IS NULL" : "FALSE";
        }
        return "(" + (column.nullable() ? columnName + " IS NULL OR " : "") + this.buildInStatement(columnName, ctx) + ')';
    }

    private String buildInStatement(String columnName, SqlBuilderContext ctx) {
        SB buf = new SB();
        this.vals.forEach(val -> {
            if (val == null) {
                return;
            }
            if (buf.length() > 0) {
                buf.a(", ");
            }
            buf.a('?');
            ctx.addArgument(val);
        });
        return columnName + " IN (" + buf + ')';
    }
}

