/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.util.Arrays;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class BinarySerializedFieldComparator {
    private static final int POS_NOT_FOUND = -1;
    private final BinaryObjectExImpl obj;
    private final byte[] arr;
    private final long ptr;
    private final int startOff;
    private final int orderBase;
    private final int orderMultiplier;
    private final int fieldOffLen;
    private int curFieldOrder;
    private int curFieldPos;

    public BinarySerializedFieldComparator(BinaryObjectExImpl obj, byte[] arr, long ptr, int startOff, int orderBase, int orderMultiplier, int fieldOffLen) {
        assert (arr != null && ptr == 0L || arr == null && ptr != 0L);
        this.obj = obj;
        this.arr = arr;
        this.ptr = ptr;
        this.startOff = startOff;
        this.orderBase = orderBase;
        this.orderMultiplier = orderMultiplier;
        this.fieldOffLen = fieldOffLen;
    }

    public void findField(int order) {
        this.curFieldOrder = order;
        if (order == -1) {
            this.curFieldPos = -1;
        } else {
            int pos = this.orderBase + order * this.orderMultiplier;
            if (this.fieldOffLen == 1) {
                byte val = this.offheap() ? BinaryPrimitives.readByte(this.ptr, pos) : BinaryPrimitives.readByte(this.arr, pos);
                this.curFieldPos = this.startOff + (val & 0xFF);
            } else if (this.fieldOffLen == 2) {
                short val = this.offheap() ? BinaryPrimitives.readShort(this.ptr, pos) : BinaryPrimitives.readShort(this.arr, pos);
                this.curFieldPos = this.startOff + (val & 0xFFFF);
            } else {
                int val = this.offheap() ? BinaryPrimitives.readInt(this.ptr, pos) : BinaryPrimitives.readInt(this.arr, pos);
                this.curFieldPos = this.startOff + val;
            }
        }
    }

    private byte fieldType() {
        if (this.curFieldPos == -1) {
            return 101;
        }
        return this.offheap() ? BinaryPrimitives.readByte(this.ptr, this.curFieldPos) : BinaryPrimitives.readByte(this.arr, this.curFieldPos);
    }

    private boolean offheap() {
        return this.ptr != 0L;
    }

    private Object currentField() {
        return this.obj.fieldByOrder(this.curFieldOrder);
    }

    private byte readByte(int off) {
        if (this.offheap()) {
            return BinaryPrimitives.readByte(this.ptr, this.curFieldPos + off);
        }
        return this.arr[this.curFieldPos + off];
    }

    private short readShort(int off) {
        if (this.offheap()) {
            return BinaryPrimitives.readShort(this.ptr, this.curFieldPos + off);
        }
        return BinaryPrimitives.readShort(this.arr, this.curFieldPos + off);
    }

    private int readInt(int off) {
        if (this.offheap()) {
            return BinaryPrimitives.readInt(this.ptr, this.curFieldPos + off);
        }
        return BinaryPrimitives.readInt(this.arr, this.curFieldPos + off);
    }

    private long readLong(int off) {
        if (this.offheap()) {
            return BinaryPrimitives.readLong(this.ptr, this.curFieldPos + off);
        }
        return BinaryPrimitives.readLong(this.arr, this.curFieldPos + off);
    }

    public static boolean equals(BinarySerializedFieldComparator c1, BinarySerializedFieldComparator c2) {
        byte typ = c1.fieldType();
        if (typ != c2.fieldType()) {
            return false;
        }
        switch (typ) {
            case 1: 
            case 8: {
                return c1.readByte(1) == c2.readByte(1);
            }
            case 2: 
            case 7: {
                return c1.readShort(1) == c2.readShort(1);
            }
            case 3: 
            case 5: {
                return c1.readInt(1) == c2.readInt(1);
            }
            case 4: 
            case 6: 
            case 11: {
                return c1.readLong(1) == c2.readLong(1);
            }
            case 33: {
                return c1.readLong(1) == c2.readLong(1) && c1.readInt(9) == c2.readInt(9);
            }
            case 36: {
                return c1.readLong(1) == c2.readLong(1);
            }
            case 10: {
                return c1.readLong(1) == c2.readLong(1) && c1.readLong(9) == c2.readLong(9);
            }
            case 9: {
                return BinarySerializedFieldComparator.compareByteArrays(c1, c2, 1);
            }
            case 30: {
                return c1.readInt(1) == c2.readInt(1) && BinarySerializedFieldComparator.compareByteArrays(c1, c2, 5);
            }
            case 101: {
                return true;
            }
        }
        Object val1 = c1.currentField();
        Object val2 = c2.currentField();
        return BinarySerializedFieldComparator.isArray(val1) ? BinarySerializedFieldComparator.compareArrays(val1, val2) : F.eq(val1, val2);
    }

    private static boolean compareArrays(Object val1, Object val2) {
        if (val1.getClass() == val2.getClass()) {
            if (val1 instanceof byte[]) {
                return Arrays.equals((byte[])val1, (byte[])val2);
            }
            if (val1 instanceof boolean[]) {
                return Arrays.equals((boolean[])val1, (boolean[])val2);
            }
            if (val1 instanceof short[]) {
                return Arrays.equals((short[])val1, (short[])val2);
            }
            if (val1 instanceof char[]) {
                return Arrays.equals((char[])val1, (char[])val2);
            }
            if (val1 instanceof int[]) {
                return Arrays.equals((int[])val1, (int[])val2);
            }
            if (val1 instanceof long[]) {
                return Arrays.equals((long[])val1, (long[])val2);
            }
            if (val1 instanceof float[]) {
                return Arrays.equals((float[])val1, (float[])val2);
            }
            if (val1 instanceof double[]) {
                return Arrays.equals((double[])val1, (double[])val2);
            }
            return Arrays.deepEquals((Object[])val1, (Object[])val2);
        }
        return false;
    }

    private static boolean isArray(@Nullable Object field) {
        return field != null && field.getClass().isArray();
    }

    private static boolean compareByteArrays(BinarySerializedFieldComparator c1, BinarySerializedFieldComparator c2, int off) {
        int len = c1.readInt(off);
        if (len != c2.readInt(off)) {
            return false;
        }
        off += 4;
        if (c1.offheap()) {
            if (c2.offheap()) {
                return GridUnsafe.compare((long)c1.curFieldPos + c1.ptr + (long)off, (long)c2.curFieldPos + c2.ptr + (long)off, len);
            }
        } else {
            if (!c2.offheap()) {
                for (int i = 0; i < len; ++i) {
                    if (c1.arr[c1.curFieldPos + off + i] == c2.arr[c2.curFieldPos + off + i]) continue;
                    return false;
                }
                return true;
            }
            BinarySerializedFieldComparator tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        assert (c1.offheap() && !c2.offheap());
        for (int i = 0; i < len; ++i) {
            if (BinaryPrimitives.readByte(c1.ptr, c1.curFieldPos + off + i) == c2.arr[c2.curFieldPos + off + i]) continue;
            return false;
        }
        return true;
    }
}

