/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.stream.Collectors;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteState;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.Ignition;
import org.apache.ignite.IgnitionListener;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.ExecutorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.configuration.MemoryPolicyConfiguration;
import org.apache.ignite.configuration.PersistentStoreConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionMXBeanAdapter;
import org.apache.ignite.internal.ShutdownPolicyHandler;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.resource.DependencyResolver;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.TimeBag;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.CA;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.mxbean.IgnitionMXBean;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.checkpoint.noop.NoopCheckpointSpi;
import org.apache.ignite.spi.collision.noop.NoopCollisionSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.deployment.local.LocalDeploymentSpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.apache.ignite.spi.eventstorage.NoopEventStorageSpi;
import org.apache.ignite.spi.failover.always.AlwaysFailoverSpi;
import org.apache.ignite.spi.indexing.noop.NoopIndexingSpi;
import org.apache.ignite.spi.loadbalancing.LoadBalancingSpi;
import org.apache.ignite.spi.loadbalancing.roundrobin.RoundRobinLoadBalancingSpi;
import org.apache.ignite.spi.metric.noop.NoopMetricExporterSpi;
import org.apache.ignite.spi.tracing.NoopTracingSpi;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class IgnitionEx {
    public static final String DFLT_CFG = "config/default-config.xml";
    public static final String SYSTEM_VIEW_SQL_SPI = "org.apache.ignite.spi.systemview.SqlViewExporterSpi";
    private static final ConcurrentMap<Object, IgniteNamedInstance> grids = new ConcurrentHashMap<Object, IgniteNamedInstance>();
    private static final Map<Object, IgniteState> gridStates = new ConcurrentHashMap<Object, IgniteState>();
    private static final Object dfltGridMux = new Object();
    private static volatile IgniteNamedInstance dfltGrid;
    private static volatile IgniteState dfltGridState;
    private static final Collection<IgnitionListener> lsnrs;
    private static ThreadLocal<Boolean> daemon;
    private static ThreadLocal<Boolean> clientMode;
    private static ThreadLocal<DependencyResolver> dependencyResolver;

    private IgnitionEx() {
    }

    public static void setDaemon(boolean daemon) {
        IgnitionEx.daemon.set(daemon);
    }

    public static boolean isDaemon() {
        return daemon.get();
    }

    public static void setClientMode(boolean clientMode) {
        IgnitionEx.clientMode.set(clientMode);
    }

    public static boolean isClientMode() {
        return clientMode.get() == null ? false : clientMode.get();
    }

    public static IgniteState state() {
        return IgnitionEx.state(null);
    }

    public static IgniteState state(@Nullable String name) {
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null) {
            IgniteState state = name != null ? gridStates.get(name) : dfltGridState;
            return state != null ? state : IgniteState.STOPPED;
        }
        return grid.state();
    }

    public static boolean stop(boolean cancel, @Nullable ShutdownPolicy shutdown) {
        return IgnitionEx.stop(null, cancel, shutdown, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stop(@Nullable String name, boolean cancel, @Nullable ShutdownPolicy shutdown, boolean stopNotStarted) {
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid != null && stopNotStarted && grid.startLatch.getCount() != 0L) {
            grid.starterThreadInterrupted = true;
            grid.starterThread.interrupt();
        }
        if (grid != null) {
            boolean fireEvt;
            if (grid.state() == IgniteState.STARTED) {
                grid.stop(cancel, shutdown);
            }
            if (name != null) {
                fireEvt = grids.remove(name, grid);
            } else {
                Object object = dfltGridMux;
                synchronized (object) {
                    boolean bl = fireEvt = dfltGrid == grid;
                    if (fireEvt) {
                        dfltGrid = null;
                    }
                }
            }
            if (fireEvt) {
                IgnitionEx.notifyStateChange(grid.getName(), grid.state());
            }
            return true;
        }
        U.warn(null, "Ignoring stopping Ignite instance that was already stopped or never started: " + name);
        return false;
    }

    @Deprecated
    public static boolean stop(final @Nullable String name, boolean cancel, boolean stopNotStarted, final long timeoutMs) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.schedule(new Runnable(){

            @Override
            public void run() {
                if (IgnitionEx.state(name) == IgniteState.STARTED) {
                    U.error(null, "Unable to gracefully stop node within timeout " + timeoutMs + " milliseconds. Killing node...");
                    Runtime.getRuntime().halt(130);
                }
            }
        }, timeoutMs, TimeUnit.MILLISECONDS);
        boolean success = IgnitionEx.stop(name, cancel, null, stopNotStarted);
        executor.shutdownNow();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll(boolean cancel, @Nullable ShutdownPolicy shutdown) {
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null) {
            boolean fireEvt;
            dfltGrid0.stop(cancel, shutdown);
            Object object = dfltGridMux;
            synchronized (object) {
                boolean bl = fireEvt = dfltGrid == dfltGrid0;
                if (fireEvt) {
                    dfltGrid = null;
                }
            }
            if (fireEvt) {
                IgnitionEx.notifyStateChange(dfltGrid0.getName(), dfltGrid0.state());
            }
        }
        for (IgniteNamedInstance grid : grids.values()) {
            grid.stop(cancel, shutdown);
            boolean fireEvt = grids.remove(grid.getName(), grid);
            if (!fireEvt) continue;
            IgnitionEx.notifyStateChange(grid.getName(), grid.state());
        }
    }

    public static void restart(boolean cancel) {
        U.log(null, "Restarting node. Will exit (250).");
        System.setProperty("IGNITE_RESTART_CODE", Integer.toString(250));
        IgnitionEx.stopAll(cancel, null);
        System.exit(250);
    }

    public static void kill(boolean cancel) {
        IgnitionEx.stopAll(cancel, null);
        System.exit(130);
    }

    public static Ignite start() throws IgniteCheckedException {
        return IgnitionEx.start((GridSpringResourceContext)null);
    }

    public static Ignite start(@Nullable GridSpringResourceContext springCtx) throws IgniteCheckedException {
        URL url = U.resolveIgniteUrl(DFLT_CFG);
        if (url != null) {
            return IgnitionEx.start(DFLT_CFG, null, springCtx, null);
        }
        U.warn(null, "Default Spring XML file not found (is IGNITE_HOME set?): config/default-config.xml");
        return ((IgniteNamedInstance)IgnitionEx.start0(new GridStartContext(new IgniteConfiguration(), null, springCtx), true).get1()).grid();
    }

    public static Ignite start(IgniteConfiguration cfg) throws IgniteCheckedException {
        return (Ignite)IgnitionEx.start(cfg, null, true).get1();
    }

    public static Ignite start(IgniteConfiguration cfg, boolean failIfStarted) throws IgniteCheckedException {
        return (Ignite)IgnitionEx.start(cfg, null, failIfStarted).get1();
    }

    public static T2<Ignite, Boolean> getOrStart(IgniteConfiguration cfg) throws IgniteException {
        try {
            return IgnitionEx.start(cfg, null, false);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public static Ignite start(IgniteConfiguration cfg, @Nullable GridSpringResourceContext springCtx) throws IgniteCheckedException {
        A.notNull(cfg, "cfg");
        return ((IgniteNamedInstance)IgnitionEx.start0(new GridStartContext(cfg, null, springCtx), true).get1()).grid();
    }

    public static T2<Ignite, Boolean> start(IgniteConfiguration cfg, @Nullable GridSpringResourceContext springCtx, boolean failIfStarted) throws IgniteCheckedException {
        A.notNull(cfg, "cfg");
        T2<IgniteNamedInstance, Boolean> res = IgnitionEx.start0(new GridStartContext(cfg, null, springCtx), failIfStarted);
        return new T2<Ignite, Boolean>(((IgniteNamedInstance)res.get1()).grid(), (Boolean)res.get2());
    }

    public static Ignite start(@Nullable String springCfgPath) throws IgniteCheckedException {
        return springCfgPath == null ? IgnitionEx.start() : IgnitionEx.start(springCfgPath, null);
    }

    public static Ignite start(@Nullable String springCfgPath, @Nullable String igniteInstanceName) throws IgniteCheckedException {
        if (springCfgPath == null) {
            IgniteConfiguration cfg = new IgniteConfiguration();
            if (cfg.getIgniteInstanceName() == null && !F.isEmpty(igniteInstanceName)) {
                cfg.setIgniteInstanceName(igniteInstanceName);
            }
            return IgnitionEx.start(cfg);
        }
        return IgnitionEx.start(springCfgPath, igniteInstanceName, null, null);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(URL springCfgUrl) throws IgniteCheckedException {
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadConfigurations(springCfgUrl, new String[0]);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(InputStream springCfgStream) throws IgniteCheckedException {
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadConfigurations(springCfgStream, new String[0]);
    }

    public static IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> loadConfigurations(String springCfgPath) throws IgniteCheckedException {
        A.notNull(springCfgPath, "springCfgPath");
        return IgnitionEx.loadConfigurations(IgniteUtils.resolveSpringUrl(springCfgPath));
    }

    public static IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext> loadConfiguration(URL springCfgUrl) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> t = IgnitionEx.loadConfigurations(springCfgUrl);
        return F.t(F.first((Iterable)t.get1()), t.get2());
    }

    public static IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext> loadConfiguration(String springCfgPath) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> t = IgnitionEx.loadConfigurations(springCfgPath);
        return F.t(F.first((Iterable)t.get1()), t.get2());
    }

    public static Ignite start(String springCfgPath, @Nullable String igniteInstanceName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        URL url = U.resolveSpringUrl(springCfgPath);
        return IgnitionEx.start(url, igniteInstanceName, springCtx, ldr);
    }

    public static Ignite start(URL springCfgUrl) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgUrl, null, null, null);
    }

    public static Ignite start(URL springCfgUrl, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgUrl, null, null, ldr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ignite start(URL springCfgUrl, @Nullable String igniteInstanceName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap;
        A.notNull(springCfgUrl, "springCfgUrl");
        boolean isLog4jUsed = U.gridClassLoader().getResource("org/apache/log4j/Appender.class") != null;
        IgniteBiTuple<Object, Object> t = null;
        if (isLog4jUsed) {
            try {
                t = U.addLog4jNoOpLogger();
            }
            catch (IgniteCheckedException ignore) {
                isLog4jUsed = false;
            }
        }
        Collection<Handler> savedHnds = null;
        if (!isLog4jUsed) {
            savedHnds = U.addJavaNoOpLogger();
        }
        try {
            cfgMap = IgnitionEx.loadConfigurations(springCfgUrl);
        }
        finally {
            if (isLog4jUsed && t != null) {
                U.removeLog4jNoOpLogger(t);
            }
            if (!isLog4jUsed) {
                U.removeJavaNoOpLogger(savedHnds);
            }
        }
        return IgnitionEx.startConfigurations(cfgMap, springCfgUrl, igniteInstanceName, springCtx, ldr);
    }

    public static Ignite start(InputStream springCfgStream) throws IgniteCheckedException {
        return IgnitionEx.start(springCfgStream, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ignite start(InputStream springCfgStream, @Nullable String igniteInstanceName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap;
        A.notNull(springCfgStream, "springCfgUrl");
        boolean isLog4jUsed = U.gridClassLoader().getResource("org/apache/log4j/Appender.class") != null;
        IgniteBiTuple<Object, Object> t = null;
        if (isLog4jUsed) {
            try {
                t = U.addLog4jNoOpLogger();
            }
            catch (IgniteCheckedException ignore) {
                isLog4jUsed = false;
            }
        }
        Collection<Handler> savedHnds = null;
        if (!isLog4jUsed) {
            savedHnds = U.addJavaNoOpLogger();
        }
        try {
            cfgMap = IgnitionEx.loadConfigurations(springCfgStream);
        }
        finally {
            if (isLog4jUsed && t != null) {
                U.removeLog4jNoOpLogger(t);
            }
            if (!isLog4jUsed) {
                U.removeJavaNoOpLogger(savedHnds);
            }
        }
        return IgnitionEx.startConfigurations(cfgMap, null, igniteInstanceName, springCtx, ldr);
    }

    private static Ignite startConfigurations(IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap, URL springCfgUrl, @Nullable String igniteInstanceName, @Nullable GridSpringResourceContext springCtx, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        ArrayList<IgniteNamedInstance> grids = new ArrayList<IgniteNamedInstance>(cfgMap.size());
        try {
            for (IgniteConfiguration cfg : cfgMap.get1()) {
                IgniteNamedInstance grid;
                assert (cfg != null);
                if (cfg.getIgniteInstanceName() == null && !F.isEmpty(igniteInstanceName)) {
                    cfg.setIgniteInstanceName(igniteInstanceName);
                }
                if (ldr != null && cfg.getClassLoader() == null) {
                    cfg.setClassLoader(ldr);
                }
                if ((grid = (IgniteNamedInstance)IgnitionEx.start0(new GridStartContext(cfg, springCfgUrl, springCtx == null ? cfgMap.get2() : springCtx), true).get1()) == null) continue;
                grids.add(grid);
            }
        }
        catch (IgniteCheckedException e) {
            for (IgniteNamedInstance grid : grids) {
                try {
                    grid.stop(true, ShutdownPolicy.IMMEDIATE);
                }
                catch (Exception e1) {
                    U.error(grid.log, "Error when stopping grid: " + grid, e1);
                }
            }
            throw e;
        }
        IgniteNamedInstance res = !grids.isEmpty() ? (IgniteNamedInstance)grids.get(0) : null;
        return res != null ? res.grid() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static T2<IgniteNamedInstance, Boolean> start0(GridStartContext startCtx, boolean failIfStarted) throws IgniteCheckedException {
        IgniteNamedInstance old;
        assert (startCtx != null);
        String name = startCtx.config().getIgniteInstanceName();
        if (name != null && name.isEmpty()) {
            throw new IgniteCheckedException("Non default Ignite instances cannot have empty string name.");
        }
        IgniteNamedInstance grid = new IgniteNamedInstance(name);
        if (name != null) {
            old = grids.putIfAbsent(name, grid);
        } else {
            Object object = dfltGridMux;
            synchronized (object) {
                old = dfltGrid;
                if (old == null) {
                    dfltGrid = grid;
                }
            }
        }
        if (old != null) {
            if (failIfStarted) {
                if (name == null) {
                    throw new IgniteCheckedException("Default Ignite instance has already been started.");
                }
                throw new IgniteCheckedException("Ignite instance with this name has already been started: " + name);
            }
            return new T2<IgniteNamedInstance, Boolean>(old, false);
        }
        if (startCtx.config().getWarmupClosure() != null) {
            startCtx.config().getWarmupClosure().apply(startCtx.config());
        }
        startCtx.single(grids.size() == 1);
        boolean success = false;
        try {
            try {
                grid.start(startCtx);
            }
            catch (Exception e) {
                if (X.hasCause((Throwable)e, IgniteInterruptedCheckedException.class, InterruptedException.class) && grid.starterThreadInterrupted) {
                    Thread.interrupted();
                }
                throw e;
            }
            IgnitionEx.notifyStateChange(name, IgniteState.STARTED);
            success = true;
        }
        finally {
            if (!success) {
                if (name != null) {
                    grids.remove(name, grid);
                } else {
                    Object object = dfltGridMux;
                    synchronized (object) {
                        if (dfltGrid == grid) {
                            dfltGrid = null;
                        }
                    }
                }
                grid = null;
            }
        }
        if (grid == null) {
            throw new IgniteCheckedException("Failed to start grid with provided configuration.");
        }
        return new T2<IgniteNamedInstance, Boolean>(grid, true);
    }

    public static <T> T loadSpringBean(String springXmlPath, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlPath, "springXmlPath");
        A.notNull(beanName, "beanName");
        URL url = U.resolveSpringUrl(springXmlPath);
        assert (url != null);
        return IgnitionEx.loadSpringBean(url, beanName);
    }

    public static <T> T loadSpringBean(URL springXmlUrl, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlUrl, "springXmlUrl");
        A.notNull(beanName, "beanName");
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadBean(springXmlUrl, beanName);
    }

    public static <T> T loadSpringBean(InputStream springXmlStream, String beanName) throws IgniteCheckedException {
        A.notNull(springXmlStream, "springXmlPath");
        A.notNull(beanName, "beanName");
        IgniteSpringHelper spring = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
        return spring.loadBean(springXmlStream, beanName);
    }

    public static Ignite grid() throws IgniteIllegalStateException {
        return IgnitionEx.grid((String)null);
    }

    public static List<Ignite> allGrids() {
        return IgnitionEx.allGrids(true);
    }

    public static List<Ignite> allGridsx() {
        return IgnitionEx.allGrids(false);
    }

    private static List<Ignite> allGrids(boolean wait) {
        ArrayList<Ignite> allIgnites = new ArrayList<Ignite>(grids.size() + 1);
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g = wait ? grid.grid() : grid.gridx();
            if (g == null) continue;
            allIgnites.add(g);
        }
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null) {
            IgniteKernal g;
            IgniteKernal igniteKernal = g = wait ? dfltGrid0.grid() : dfltGrid0.gridx();
            if (g != null) {
                allIgnites.add(g);
            }
        }
        return allIgnites;
    }

    public static Ignite grid(UUID locNodeId) throws IgniteIllegalStateException {
        IgniteKernal g;
        A.notNull(locNodeId, "locNodeId");
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null && (g = dfltGrid0.grid()) != null && g.getLocalNodeId().equals(locNodeId)) {
            return g;
        }
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g2 = grid.grid();
            if (g2 == null || !g2.getLocalNodeId().equals(locNodeId)) continue;
            return g2;
        }
        throw new IgniteIllegalStateException("Grid instance with given local node ID was not properly started or was stopped: " + locNodeId);
    }

    public static IgniteKernal gridxx(UUID locNodeId) {
        IgniteKernal g;
        IgniteNamedInstance dfltGrid0 = dfltGrid;
        if (dfltGrid0 != null && (g = dfltGrid0.grid()) != null && g.getLocalNodeId().equals(locNodeId)) {
            return g;
        }
        for (IgniteNamedInstance grid : grids.values()) {
            IgniteKernal g2 = grid.grid();
            if (g2 == null || !g2.getLocalNodeId().equals(locNodeId)) continue;
            return g2;
        }
        return null;
    }

    public static Ignite grid(@Nullable String name) throws IgniteIllegalStateException {
        IgniteKernal res;
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null || (res = grid.grid()) == null) {
            throw new IgniteIllegalStateException("Ignite instance with provided name doesn't exist. Did you call Ignition.start(..) to start an Ignite instance? [name=" + name + ']');
        }
        return res;
    }

    public static IgniteKernal localIgnite() throws IllegalArgumentException {
        String name = U.getCurrentIgniteName();
        if (U.isCurrentIgniteNameSet(name)) {
            return IgnitionEx.gridx(name);
        }
        if (Thread.currentThread() instanceof IgniteThread) {
            return IgnitionEx.gridx(((IgniteThread)Thread.currentThread()).getIgniteInstanceName());
        }
        throw new IllegalArgumentException("Ignite instance name thread local must be set or this method should be accessed under " + IgniteThread.class.getName());
    }

    public static IgniteKernal gridx(@Nullable String name) {
        IgniteKernal res;
        IgniteNamedInstance grid;
        IgniteNamedInstance igniteNamedInstance = grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        if (grid == null || (res = grid.gridx()) == null) {
            throw new IgniteIllegalStateException("Ignite instance with provided name doesn't exist. Did you call Ignition.start(..) to start an Ignite instance? [name=" + name + ']');
        }
        return res;
    }

    public static void addListener(IgnitionListener lsnr) {
        A.notNull(lsnr, "lsnr");
        lsnrs.add(lsnr);
    }

    public static boolean removeListener(IgnitionListener lsnr) {
        A.notNull(lsnr, "lsnr");
        return lsnrs.remove(lsnr);
    }

    private static void notifyStateChange(@Nullable String igniteInstanceName, IgniteState state) {
        if (igniteInstanceName != null) {
            gridStates.put(igniteInstanceName, state);
        } else {
            dfltGridState = state;
        }
        for (IgnitionListener lsnr : lsnrs) {
            lsnr.onStateChange(igniteInstanceName, state);
        }
    }

    public static void dependencyResolver(DependencyResolver rslvr) {
        dependencyResolver.set(rslvr);
    }

    public static DependencyResolver dependencyResolver() {
        return dependencyResolver.get();
    }

    public static boolean hasKernalStarted(String name) {
        IgniteNamedInstance grid = name != null ? (IgniteNamedInstance)grids.get(name) : dfltGrid;
        return grid != null && grid.hasStartLatchCompleted();
    }

    public static void initializeDefaultMBeanServer(IgniteConfiguration myCfg) {
        if (myCfg.getMBeanServer() == null && !U.IGNITE_MBEANS_DISABLED) {
            myCfg.setMBeanServer(ManagementFactory.getPlatformMBeanServer());
        }
    }

    private static void convertLegacyDataStorageConfigurationToNew(IgniteConfiguration cfg) throws IgniteCheckedException {
        PersistentStoreConfiguration psCfg = cfg.getPersistentStoreConfiguration();
        boolean persistenceEnabled = psCfg != null;
        DataStorageConfiguration dsCfg = new DataStorageConfiguration();
        MemoryConfiguration memCfg = cfg.getMemoryConfiguration() != null ? cfg.getMemoryConfiguration() : new MemoryConfiguration();
        dsCfg.setConcurrencyLevel(memCfg.getConcurrencyLevel());
        dsCfg.setPageSize(memCfg.getPageSize());
        dsCfg.setSystemRegionInitialSize(memCfg.getSystemCacheInitialSize());
        dsCfg.setSystemRegionMaxSize(memCfg.getSystemCacheMaxSize());
        ArrayList<DataRegionConfiguration> optionalDataRegions = new ArrayList<DataRegionConfiguration>();
        boolean customDfltPlc = false;
        if (memCfg.getMemoryPolicies() != null) {
            for (MemoryPolicyConfiguration mpc : memCfg.getMemoryPolicies()) {
                DataRegionConfiguration region = new DataRegionConfiguration();
                region.setPersistenceEnabled(persistenceEnabled);
                if (mpc.getInitialSize() != 0L) {
                    region.setInitialSize(mpc.getInitialSize());
                }
                region.setEmptyPagesPoolSize(mpc.getEmptyPagesPoolSize());
                region.setEvictionThreshold(mpc.getEvictionThreshold());
                region.setMaxSize(mpc.getMaxSize());
                region.setName(mpc.getName());
                region.setPageEvictionMode(mpc.getPageEvictionMode());
                region.setMetricsRateTimeInterval(mpc.getRateTimeInterval());
                region.setMetricsSubIntervalCount(mpc.getSubIntervals());
                region.setSwapPath(mpc.getSwapFilePath());
                region.setMetricsEnabled(mpc.isMetricsEnabled());
                if (persistenceEnabled) {
                    region.setCheckpointPageBufferSize(psCfg.getCheckpointingPageBufferSize());
                }
                if (mpc.getName() == null) {
                    throw new IgniteCheckedException(new IllegalArgumentException("User-defined MemoryPolicyConfiguration must have non-null and non-empty name."));
                }
                if (mpc.getName().equals(memCfg.getDefaultMemoryPolicyName())) {
                    customDfltPlc = true;
                    dsCfg.setDefaultDataRegionConfiguration(region);
                    continue;
                }
                optionalDataRegions.add(region);
            }
        }
        if (!optionalDataRegions.isEmpty()) {
            dsCfg.setDataRegionConfigurations(optionalDataRegions.toArray(new DataRegionConfiguration[optionalDataRegions.size()]));
        }
        if (!customDfltPlc) {
            if (!"default".equals(memCfg.getDefaultMemoryPolicyName())) {
                throw new IgniteCheckedException(new IllegalArgumentException("User-defined default MemoryPolicy name must be presented among configured MemoryPolices: " + memCfg.getDefaultMemoryPolicyName()));
            }
            dsCfg.setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(memCfg.getDefaultMemoryPolicySize()).setName(memCfg.getDefaultMemoryPolicyName()).setPersistenceEnabled(persistenceEnabled));
        } else if (memCfg.getDefaultMemoryPolicySize() != MemoryConfiguration.DFLT_MEMORY_POLICY_MAX_SIZE) {
            throw new IgniteCheckedException(new IllegalArgumentException("User-defined MemoryPolicy configuration and defaultMemoryPolicySize properties are set at the same time."));
        }
        if (persistenceEnabled) {
            dsCfg.setCheckpointFrequency(psCfg.getCheckpointingFrequency());
            dsCfg.setCheckpointThreads(psCfg.getCheckpointingThreads());
            dsCfg.setCheckpointWriteOrder(psCfg.getCheckpointWriteOrder());
            dsCfg.setFileIOFactory(psCfg.getFileIOFactory());
            dsCfg.setLockWaitTime(psCfg.getLockWaitTime());
            dsCfg.setStoragePath(psCfg.getPersistentStorePath());
            dsCfg.setMetricsRateTimeInterval(psCfg.getRateTimeInterval());
            dsCfg.setMetricsSubIntervalCount(psCfg.getSubIntervals());
            dsCfg.setWalThreadLocalBufferSize(psCfg.getTlbSize());
            dsCfg.setWalArchivePath(psCfg.getWalArchivePath());
            dsCfg.setWalAutoArchiveAfterInactivity(psCfg.getWalAutoArchiveAfterInactivity());
            dsCfg.setWalFlushFrequency(psCfg.getWalFlushFrequency());
            dsCfg.setWalFsyncDelayNanos(psCfg.getWalFsyncDelayNanos());
            dsCfg.setWalHistorySize(psCfg.getWalHistorySize());
            dsCfg.setWalMode(psCfg.getWalMode());
            dsCfg.setWalRecordIteratorBufferSize(psCfg.getWalRecordIteratorBufferSize());
            dsCfg.setWalSegments(psCfg.getWalSegments());
            dsCfg.setWalSegmentSize(psCfg.getWalSegmentSize());
            dsCfg.setWalPath(psCfg.getWalStorePath());
            dsCfg.setAlwaysWriteFullPages(psCfg.isAlwaysWriteFullPages());
            dsCfg.setMetricsEnabled(psCfg.isMetricsEnabled());
            dsCfg.setWriteThrottlingEnabled(psCfg.isWriteThrottlingEnabled());
        }
        cfg.setDataStorageConfiguration(dsCfg);
    }

    static {
        lsnrs = new GridConcurrentHashSet<IgnitionListener>(4);
        daemon = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        clientMode = new ThreadLocal();
        dependencyResolver = new ThreadLocal();
    }

    private static final class IgniteNamedInstance {
        private static final Map<MBeanServer, GridMBeanServerData> mbeans = new HashMap<MBeanServer, GridMBeanServerData>();
        private static final String[] EMPTY_STR_ARR = new String[0];
        private final String name;
        private volatile IgniteKernal grid;
        private volatile IgniteState state = IgniteState.STOPPED;
        private Thread shutdownHook;
        private IgniteLogger log;
        private final AtomicBoolean startGuard = new AtomicBoolean();
        private final CountDownLatch startLatch = new CountDownLatch(1);
        private final AtomicReference<ShutdownPolicyHandler> shutdownPlcHnd = new AtomicReference();
        private Thread starterThread;
        private boolean starterThreadInterrupted;

        IgniteNamedInstance(@Nullable String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        IgniteKernal grid() {
            if (this.starterThread != Thread.currentThread()) {
                U.awaitQuiet(this.startLatch);
            }
            return this.grid;
        }

        public IgniteKernal gridx() {
            return this.grid;
        }

        IgniteState state() {
            if (this.starterThread != Thread.currentThread()) {
                U.awaitQuiet(this.startLatch);
            }
            return this.state;
        }

        private void ensureMultiInstanceSupport(IgniteSpi spi) throws IgniteCheckedException {
            IgniteSpiMultipleInstancesSupport ann = U.getAnnotation(spi.getClass(), IgniteSpiMultipleInstancesSupport.class);
            if (ann == null || !ann.value()) {
                throw new IgniteCheckedException("SPI implementation doesn't support multiple grid instances in the same VM: " + spi);
            }
        }

        private void ensureMultiInstanceSupport(IgniteSpi[] spis) throws IgniteCheckedException {
            for (IgniteSpi spi : spis) {
                this.ensureMultiInstanceSupport(spi);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        synchronized void start(GridStartContext startCtx) throws IgniteCheckedException {
            if (this.startGuard.compareAndSet(false, true)) {
                try {
                    this.starterThread = Thread.currentThread();
                    IgniteConfiguration myCfg = this.initializeConfiguration(startCtx.config() != null ? startCtx.config() : new IgniteConfiguration());
                    TimeBag startNodeTimer = new TimeBag(TimeUnit.MILLISECONDS);
                    this.start0(startCtx, myCfg, startNodeTimer);
                    if (!this.log.isInfoEnabled()) return;
                    this.log.info("Node started : " + startNodeTimer.stagesTimings().stream().collect(Collectors.joining(",", "[", "]")));
                    return;
                }
                finally {
                    this.startLatch.countDown();
                }
            } else {
                U.awaitQuiet(this.startLatch);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void start0(GridStartContext startCtx, IgniteConfiguration cfg, TimeBag startTimer) throws IgniteCheckedException {
            assert (this.grid == null) : "Grid is already started: " + this.name;
            if (startCtx.configUrl() != null) {
                System.setProperty("IGNITE_CONFIG_URL", startCtx.configUrl().toString());
            }
            if (!startCtx.single()) {
                this.ensureMultiInstanceSupport(cfg.getDeploymentSpi());
                this.ensureMultiInstanceSupport(cfg.getCommunicationSpi());
                this.ensureMultiInstanceSupport(cfg.getDiscoverySpi());
                this.ensureMultiInstanceSupport(cfg.getCheckpointSpi());
                this.ensureMultiInstanceSupport(cfg.getEventStorageSpi());
                this.ensureMultiInstanceSupport(cfg.getCollisionSpi());
                this.ensureMultiInstanceSupport(cfg.getFailoverSpi());
                this.ensureMultiInstanceSupport(cfg.getLoadBalancingSpi());
            }
            Thread.UncaughtExceptionHandler oomeHnd = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (grid != null && X.hasCause(e, OutOfMemoryError.class)) {
                        grid.context().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                    }
                }
            };
            WorkersRegistry workerRegistry = new WorkersRegistry(new IgniteBiInClosure<GridWorker, FailureType>(){

                @Override
                public void apply(GridWorker worker, FailureType failureType) {
                    IgniteException ex = new IgniteException(S.toString(GridWorker.class, worker));
                    Thread runner = worker.runner();
                    if (runner != null && runner != Thread.currentThread()) {
                        ex.setStackTrace(runner.getStackTrace());
                    }
                    if (grid != null) {
                        grid.context().failure().process(new FailureContext(failureType, ex));
                    }
                }
            }, IgniteSystemProperties.getLong("IGNITE_SYSTEM_WORKER_BLOCKED_TIMEOUT", cfg.getSystemWorkerBlockedTimeout() != null ? cfg.getSystemWorkerBlockedTimeout() : cfg.getFailureDetectionTimeout()), this.log);
            this.registerFactoryMbean(cfg.getMBeanServer());
            boolean started = false;
            try {
                IgniteKernal grid0;
                this.grid = grid0 = new IgniteKernal(startCtx.springContext());
                startTimer.finishGlobalStage("Configure system pool");
                grid0.start(cfg, new CA(){

                    @Override
                    public void apply() {
                        startLatch.countDown();
                    }
                }, workerRegistry, oomeHnd, startTimer);
                this.state = IgniteState.STARTED;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Grid factory started ok: " + this.name);
                }
                started = true;
            }
            catch (IgniteCheckedException e) {
                this.unregisterFactoryMBean();
                throw e;
            }
            catch (Throwable e) {
                this.unregisterFactoryMBean();
                if (!(e instanceof Error)) throw new IgniteCheckedException("Unexpected exception when starting grid.", e);
                throw e;
            }
            finally {
                if (!started) {
                    this.grid = null;
                }
            }
            if (!IgniteSystemProperties.getBoolean("IGNITE_NO_SHUTDOWN_HOOK", false)) {
                try {
                    this.shutdownHook = new Thread("shutdown-hook"){

                        @Override
                        public void run() {
                            if (log.isInfoEnabled()) {
                                log.info("Invoking shutdown hook...");
                            }
                            IgniteNamedInstance ignite = this;
                            ignite.stop(true, null);
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug("Shutdown hook is installed.");
                    return;
                }
                catch (IllegalStateException e) {
                    this.stop(true, ShutdownPolicy.IMMEDIATE);
                    throw new IgniteCheckedException("Failed to install shutdown hook.", e);
                }
            } else {
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Shutdown hook has not been installed because environment or system property IGNITE_NO_SHUTDOWN_HOOK is set.");
            }
        }

        private IgniteConfiguration initializeConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
            String depModeName;
            File ggHomeFile;
            IgniteConfiguration myCfg = new IgniteConfiguration(cfg);
            String ggHome = cfg.getIgniteHome();
            if (ggHome == null) {
                ggHome = U.getIgniteHome();
            } else {
                U.setIgniteHome(ggHome);
            }
            String userProvidedWorkDir = cfg.getWorkDirectory();
            String workDir = U.workDirectory(userProvidedWorkDir, ggHome);
            myCfg.setWorkDirectory(workDir);
            assert (F.eq(this.name, cfg.getIgniteInstanceName()));
            UUID nodeId = cfg.getNodeId() != null ? cfg.getNodeId() : UUID.randomUUID();
            myCfg.setNodeId(nodeId);
            String predefineConsistentId = IgniteSystemProperties.getString("IGNITE_OVERRIDE_CONSISTENT_ID");
            if (!F.isEmpty(predefineConsistentId)) {
                myCfg.setConsistentId((Serializable)((Object)predefineConsistentId));
            }
            IgniteLogger cfgLog = U.initLogger(cfg.getGridLogger(), null, nodeId, workDir);
            assert (cfgLog != null);
            cfgLog = new GridLoggerProxy(cfgLog, null, this.name, U.id8(nodeId));
            this.log = cfgLog.getLogger(G.class);
            myCfg.setGridLogger(cfgLog);
            if (F.isEmpty(userProvidedWorkDir) && F.isEmpty(U.IGNITE_WORK_DIR)) {
                this.log.warning("Ignite work directory is not provided, automatically resolved to: " + workDir);
            }
            if (!(ggHome == null || (ggHomeFile = new File(ggHome)).exists() && ggHomeFile.isDirectory())) {
                throw new IgniteCheckedException("Invalid Ignite installation home folder: " + ggHome);
            }
            myCfg.setIgniteHome(ggHome);
            SegmentationPolicy segPlc = cfg.getSegmentationPolicy();
            if (!F.isEmpty(cfg.getSegmentationResolvers()) && segPlc == SegmentationPolicy.RESTART_JVM && !cfg.isWaitForSegmentOnStart()) {
                U.warn(this.log, "Found potential configuration problem (forgot to enable waiting for segmenton start?) [segPlc=" + (Object)((Object)segPlc) + ", wait=false]");
            }
            if (CU.isPersistenceEnabled(cfg) && myCfg.getConsistentId() == null) {
                U.warn(this.log, "Consistent ID is not set, it is recommended to set consistent ID for production clusters (use IgniteConfiguration.setConsistentId property)");
            }
            myCfg.setTransactionConfiguration(myCfg.getTransactionConfiguration() != null ? new TransactionConfiguration(myCfg.getTransactionConfiguration()) : null);
            myCfg.setConnectorConfiguration(myCfg.getConnectorConfiguration() != null ? new ConnectorConfiguration(myCfg.getConnectorConfiguration()) : null);
            String locHost = IgniteSystemProperties.getString("IGNITE_LOCAL_HOST");
            myCfg.setLocalHost(F.isEmpty(locHost) ? myCfg.getLocalHost() : locHost);
            if (((Boolean)daemon.get()).booleanValue()) {
                myCfg.setDaemon(true);
            }
            if (myCfg.isClientMode() == null) {
                Boolean threadClient = (Boolean)clientMode.get();
                if (threadClient == null) {
                    myCfg.setClientMode(IgniteSystemProperties.getBoolean("IGNITE_CACHE_CLIENT"));
                } else {
                    myCfg.setClientMode(threadClient);
                }
            }
            if (!F.isEmpty(depModeName = IgniteSystemProperties.getString("IGNITE_DEPLOYMENT_MODE_OVERRIDE"))) {
                if (!F.isEmpty(myCfg.getCacheConfiguration())) {
                    U.quietAndInfo(this.log, "Skipping deployment mode override for caches (custom closure execution may not work for console Visor)");
                } else {
                    try {
                        DeploymentMode depMode = DeploymentMode.valueOf(depModeName);
                        if (myCfg.getDeploymentMode() != depMode) {
                            myCfg.setDeploymentMode(depMode);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new IgniteCheckedException("Failed to override deployment mode using system property (are there any misspellings?)[name=IGNITE_DEPLOYMENT_MODE_OVERRIDE, value=" + depModeName + ']', e);
                    }
                }
            }
            if (myCfg.getUserAttributes() == null) {
                myCfg.setUserAttributes(Collections.emptyMap());
            }
            IgnitionEx.initializeDefaultMBeanServer(myCfg);
            if (myCfg.getPeerClassLoadingLocalClassPathExclude() == null) {
                myCfg.setPeerClassLoadingLocalClassPathExclude(EMPTY_STR_ARR);
            }
            this.initializeDefaultSpi(myCfg);
            GridDiscoveryManager.initCommunicationErrorResolveConfiguration(myCfg);
            this.initializeDefaultCacheConfiguration(myCfg);
            ExecutorConfiguration[] execCfgs = myCfg.getExecutorConfiguration();
            if (execCfgs != null) {
                ExecutorConfiguration[] clone = (ExecutorConfiguration[])execCfgs.clone();
                for (int i = 0; i < execCfgs.length; ++i) {
                    clone[i] = new ExecutorConfiguration(execCfgs[i]);
                }
                myCfg.setExecutorConfiguration(clone);
            }
            this.initializeDataStorageConfiguration(myCfg);
            return myCfg;
        }

        private void initializeDataStorageConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
            if (cfg.getDataStorageConfiguration() != null && (cfg.getMemoryConfiguration() != null || cfg.getPersistentStoreConfiguration() != null)) {
                throw new IgniteCheckedException("Data storage can be configured with either legacy (MemoryConfiguration, PersistentStoreConfiguration) or new (DataStorageConfiguration) classes, but not both.");
            }
            if (cfg.getMemoryConfiguration() != null || cfg.getPersistentStoreConfiguration() != null) {
                IgnitionEx.convertLegacyDataStorageConfigurationToNew(cfg);
            }
            if (!cfg.isClientMode().booleanValue() && cfg.getDataStorageConfiguration() == null) {
                cfg.setDataStorageConfiguration(new DataStorageConfiguration());
            }
        }

        public void initializeDefaultCacheConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
            ArrayList<CacheConfiguration> cacheCfgs = new ArrayList<CacheConfiguration>();
            cacheCfgs.add(IgniteNamedInstance.utilitySystemCache());
            CacheConfiguration[] userCaches = cfg.getCacheConfiguration();
            if (userCaches != null && userCaches.length > 0) {
                if (!U.discoOrdered(cfg.getDiscoverySpi()) && !U.relaxDiscoveryOrdered()) {
                    throw new IgniteCheckedException("Discovery SPI implementation does not support node ordering and cannot be used with cache (use SPI with @DiscoverySpiOrderSupport annotation, like TcpDiscoverySpi)");
                }
                for (CacheConfiguration ccfg : userCaches) {
                    if (!CU.isCacheTemplateName(ccfg.getName()) && CU.containsInvalidFileNameChars(ccfg, cfg.getDataStorageConfiguration())) {
                        throw new IgniteCheckedException("Cache start failed. Cache or group name contains the characters that are not allowed in file names [cache=" + ccfg.getName() + (ccfg.getGroupName() == null ? "" : ", group=" + ccfg.getGroupName()) + ']');
                    }
                    if (CU.isReservedCacheName(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"" + ccfg.getName() + "\" because it is reserved for internal purposes.");
                    }
                    if (DataStructuresProcessor.isDataStructureCache(ccfg.getName())) {
                        throw new IgniteCheckedException("Cache name cannot be \"" + ccfg.getName() + "\" because it is reserved for data structures.");
                    }
                    cacheCfgs.add(ccfg);
                }
            }
            cfg.setCacheConfiguration(cacheCfgs.toArray(new CacheConfiguration[cacheCfgs.size()]));
            assert (cfg.getCacheConfiguration() != null);
        }

        private void initializeDefaultSpi(IgniteConfiguration cfg) {
            TcpDiscoverySpi tcpDisco;
            if (cfg.getDiscoverySpi() == null) {
                cfg.setDiscoverySpi(new TcpDiscoverySpi());
            }
            if (cfg.getDiscoverySpi() instanceof TcpDiscoverySpi && (tcpDisco = (TcpDiscoverySpi)cfg.getDiscoverySpi()).getIpFinder() == null) {
                TcpDiscoveryVmIpFinder vmIpFinder = new TcpDiscoveryVmIpFinder(true);
                String addr = "127.0.0.1:47500..47600";
                vmIpFinder.setAddresses(Collections.singletonList(addr));
                tcpDisco.setIpFinder(vmIpFinder);
            }
            if (cfg.getCommunicationSpi() == null) {
                cfg.setCommunicationSpi(new TcpCommunicationSpi());
            }
            if (cfg.getDeploymentSpi() == null) {
                cfg.setDeploymentSpi(new LocalDeploymentSpi());
            }
            if (cfg.getEventStorageSpi() == null) {
                cfg.setEventStorageSpi(new NoopEventStorageSpi());
            }
            if (cfg.getCheckpointSpi() == null) {
                cfg.setCheckpointSpi(new NoopCheckpointSpi());
            }
            if (cfg.getCollisionSpi() == null) {
                cfg.setCollisionSpi(new NoopCollisionSpi());
            }
            if (cfg.getFailoverSpi() == null) {
                cfg.setFailoverSpi(new AlwaysFailoverSpi());
            }
            if (cfg.getLoadBalancingSpi() == null) {
                cfg.setLoadBalancingSpi(new RoundRobinLoadBalancingSpi());
            } else {
                ArrayList<LoadBalancingSpi> spis = new ArrayList<LoadBalancingSpi>();
                boolean dfltLoadBalancingSpi = false;
                for (LoadBalancingSpi spi : cfg.getLoadBalancingSpi()) {
                    spis.add(spi);
                    if (dfltLoadBalancingSpi || !(spi instanceof RoundRobinLoadBalancingSpi)) continue;
                    dfltLoadBalancingSpi = true;
                }
                if (!dfltLoadBalancingSpi) {
                    spis.add(new RoundRobinLoadBalancingSpi());
                }
                cfg.setLoadBalancingSpi(spis.toArray(new LoadBalancingSpi[spis.size()]));
            }
            if (cfg.getIndexingSpi() == null) {
                cfg.setIndexingSpi(new NoopIndexingSpi());
            }
            if (cfg.getEncryptionSpi() == null) {
                cfg.setEncryptionSpi(new NoopEncryptionSpi());
            }
            if (F.isEmpty(cfg.getMetricExporterSpi())) {
                cfg.setMetricExporterSpi(new NoopMetricExporterSpi());
            }
            if (cfg.getTracingSpi() == null) {
                cfg.setTracingSpi(new NoopTracingSpi());
            }
        }

        private static CacheConfiguration utilitySystemCache() {
            CacheConfiguration cache = new CacheConfiguration();
            cache.setName("ignite-sys-cache");
            cache.setCacheMode(CacheMode.REPLICATED);
            cache.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            cache.setRebalanceMode(CacheRebalanceMode.SYNC);
            cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            cache.setAffinity(new RendezvousAffinityFunction(false, 100));
            cache.setNodeFilter(CacheConfiguration.ALL_NODES);
            cache.setRebalanceOrder(-2);
            cache.setCopyOnRead(false);
            cache.setMaxConcurrentAsyncOperations(Integer.MAX_VALUE);
            return cache;
        }

        void stop(boolean cancel, ShutdownPolicy shutdown) {
            ShutdownPolicyHandler plc;
            assert (this.startGuard.get());
            if (shutdown == null) {
                shutdown = this.determineShutdownPolicy();
            }
            if (shutdown == ShutdownPolicy.IMMEDIATE && !this.shutdownPlcHnd.compareAndSet(null, plc = ShutdownPolicyHandler.create(ShutdownPolicy.IMMEDIATE, this.grid, this.log))) {
                this.shutdownPlcHnd.get().stopHandling();
            }
            this.stop0(cancel, shutdown);
        }

        private ShutdownPolicy determineShutdownPolicy() {
            if (IgniteSystemProperties.getBoolean("IGNITE_WAIT_FOR_BACKUPS_ON_SHUTDOWN")) {
                return ShutdownPolicy.GRACEFUL;
            }
            return this.grid.cluster().shutdownPolicy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void stop0(boolean cancel, ShutdownPolicy shutdown) {
            IgniteKernal grid0;
            block13: {
                grid0 = this.grid;
                if (grid0 == null) {
                    if (this.log != null) {
                        U.warn(this.log, "Attempting to stop an already stopped Ignite instance (ignore): " + this.name);
                    }
                    return;
                }
                if (this.shutdownHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                        this.shutdownHook = null;
                        if (this.log != null && this.log.isDebugEnabled()) {
                            this.log.debug("Shutdown hook is removed.");
                        }
                    }
                    catch (IllegalStateException e) {
                        if (this.log == null || !this.log.isDebugEnabled()) break block13;
                        this.log.debug("Shutdown is in progress (ignoring): " + e.getMessage());
                    }
                }
            }
            this.shutdownPlcHnd.compareAndSet(null, ShutdownPolicyHandler.create(shutdown, grid0, this.log));
            this.shutdownPlcHnd.get().handle();
            this.unregisterFactoryMBean();
            try {
                grid0.stop(cancel);
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug("Ignite instance stopped ok: " + this.name);
                }
            }
            catch (Throwable e) {
                U.error(this.log, "Failed to properly stop grid instance due to undeclared exception.", e);
                if (e instanceof Error) {
                    throw e;
                }
            }
            finally {
                this.state = grid0.context().segmented() ? IgniteState.STOPPED_ON_SEGMENTATION : (grid0.context().invalid() ? IgniteState.STOPPED_ON_FAILURE : IgniteState.STOPPED);
                this.grid = null;
                this.log = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerFactoryMbean(MBeanServer srv) throws IgniteCheckedException {
            if (U.IGNITE_MBEANS_DISABLED) {
                return;
            }
            assert (srv != null);
            Map<MBeanServer, GridMBeanServerData> map = mbeans;
            synchronized (map) {
                GridMBeanServerData data = mbeans.get(srv);
                if (data == null) {
                    try {
                        IgnitionMXBeanAdapter mbean = new IgnitionMXBeanAdapter();
                        ObjectName objName = U.makeMBeanName(null, "Kernal", Ignition.class.getSimpleName());
                        if (!srv.queryMBeans(objName, null).isEmpty()) {
                            throw new IgniteCheckedException("MBean was already registered: " + objName);
                        }
                        objName = U.registerMBean(srv, null, "Kernal", Ignition.class.getSimpleName(), mbean, IgnitionMXBean.class);
                        data = new GridMBeanServerData(objName);
                        mbeans.put(srv, data);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Registered MBean: " + objName);
                        }
                    }
                    catch (JMException e) {
                        throw new IgniteCheckedException("Failed to register MBean.", e);
                    }
                }
                assert (data != null);
                data.addIgniteInstance(this.name);
                data.setCounter(data.getCounter() + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterFactoryMBean() {
            if (U.IGNITE_MBEANS_DISABLED) {
                return;
            }
            Map<MBeanServer, GridMBeanServerData> map = mbeans;
            synchronized (map) {
                Iterator<Map.Entry<MBeanServer, GridMBeanServerData>> iter = mbeans.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<MBeanServer, GridMBeanServerData> entry = iter.next();
                    if (!entry.getValue().containsIgniteInstance(this.name)) continue;
                    GridMBeanServerData data = entry.getValue();
                    assert (data != null);
                    if (data.getCounter() == 1) {
                        try {
                            entry.getKey().unregisterMBean(data.getMbean());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Unregistered MBean: " + data.getMbean());
                            }
                        }
                        catch (JMException e) {
                            U.error(this.log, "Failed to unregister MBean.", e);
                        }
                        iter.remove();
                        continue;
                    }
                    data.setCounter(data.getCounter() - 1);
                    data.removeIgniteInstance(this.name);
                }
            }
        }

        public boolean hasStartLatchCompleted() {
            return this.startLatch.getCount() == 0L;
        }

        private static class GridMBeanServerData {
            private Collection<String> igniteInstanceNames = new HashSet<String>();
            private ObjectName mbean;
            private int cnt;

            GridMBeanServerData(ObjectName mbean) {
                assert (mbean != null);
                this.mbean = mbean;
            }

            public void addIgniteInstance(String igniteInstanceName) {
                this.igniteInstanceNames.add(igniteInstanceName);
            }

            public void removeIgniteInstance(String igniteInstanceName) {
                this.igniteInstanceNames.remove(igniteInstanceName);
            }

            public boolean containsIgniteInstance(String igniteInstanceName) {
                return this.igniteInstanceNames.contains(igniteInstanceName);
            }

            public ObjectName getMbean() {
                return this.mbean;
            }

            public int getCounter() {
                return this.cnt;
            }

            public void setCounter(int cnt) {
                this.cnt = cnt;
            }
        }
    }

    private static final class GridStartContext {
        private IgniteConfiguration cfg;
        private URL cfgUrl;
        private GridSpringResourceContext springCtx;
        private boolean single;

        GridStartContext(IgniteConfiguration cfg, @Nullable URL cfgUrl, @Nullable GridSpringResourceContext springCtx) {
            assert (cfg != null);
            this.cfg = cfg;
            this.cfgUrl = cfgUrl;
            this.springCtx = springCtx;
        }

        public boolean single() {
            return this.single;
        }

        public void single(boolean single) {
            this.single = single;
        }

        IgniteConfiguration config() {
            return this.cfg;
        }

        void config(IgniteConfiguration cfg) {
            this.cfg = cfg;
        }

        URL configUrl() {
            return this.cfgUrl;
        }

        void configUrl(URL cfgUrl) {
            this.cfgUrl = cfgUrl;
        }

        public GridSpringResourceContext springContext() {
            return this.springCtx;
        }
    }
}

