/*
 * Decompiled with CFR 0.152.
 */
package com.gridgain.cdc.gg9togg8;

import com.gridgain.cdc.gg9togg8.ConversionService;
import com.gridgain.cdc.gg9togg8.ConversionServiceImpl;
import com.gridgain.cdc.gg9togg8.meta.Gg8TableMetadata;
import com.gridgain.cdc.gg9togg8.meta.Gg9TableMetadata;
import com.gridgain.cdc.gg9togg8.meta.MetadataUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Tuple;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.TableSink;

public class GridGain8TableSink
implements TableSink {
    private IgniteClient cl;
    private Connection conn;
    private ConversionService conversionService;
    private ClientCache<Object, Object> cache;

    public void init(QualifiedName tableName, List<Column> columns, SinkDefinition sinkDefinition) {
        Map params = sinkDefinition.parameters().parameters();
        String addr = (String)params.get("gg8-cluster-addresses");
        this.cl = Ignition.startClient(new ClientConfiguration().setAddresses(addr));
        try {
            Class.forName("org.apache.ignite.IgniteJdbcThinDriver");
            this.conn = DriverManager.getConnection("jdbc:ignite:thin://" + addr);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
        Gg9TableMetadata gg9TabMeta = MetadataUtils.getGg9TableMetadata(tableName, columns);
        Gg8TableMetadata gg8TabMeta = MetadataUtils.getGg8TableMetadata(this.cl, this.conn, tableName);
        this.cache = this.cl.cache(gg8TabMeta.cacheName());
        this.conversionService = new ConversionServiceImpl(gg8TabMeta, gg9TabMeta, this.cl.binary());
    }

    public void writeBatch(List<Tuple> batch) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void writeKvBatch(List<Map.Entry<Tuple, Tuple>> kvBatch) {
        HashMap<Object, Object> batch = new HashMap<Object, Object>();
        for (Map.Entry<Tuple, Tuple> e : kvBatch) {
            Tuple key = e.getKey();
            Tuple val = e.getValue();
            Object resKey = this.conversionService.convertKeyTuple(key);
            Object resVal = this.conversionService.convertValTuple(val);
            batch.put(resKey, resVal);
        }
        this.cache.putAll(batch);
    }

    public void updateKvBatch(List<Map.Entry<Tuple, Tuple>> list) {
    }

    public void removeBatch(List<Tuple> list) {
    }

    public void flush() {
    }

    public void close() {
        this.cl.close();
    }
}

