/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.gg8.sink;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.gridgain.internal.cdc.api.Violation;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.TableSinkValidator;

public class GridGain8TableSinkValidator
implements TableSinkValidator {
    private static final IgniteLogger LOG = Loggers.forClass(GridGain8TableSinkValidator.class);

    public List<Violation> validate(SinkDefinition definition) {
        return this.checkConfiguration(definition);
    }

    private List<Violation> checkConfiguration(SinkDefinition def) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        try {
            Map params = def.parameters().parameters();
            String options = (String)params.get("options");
            if (options == null || options.isBlank()) {
                violations.add(Violation.builder().name("Missing or incorrect configuration for GridGain 8 sink").errorDetails("Parameter options is required and must not be empty").build());
                return violations;
            }
            Config config = ConfigFactory.parseString((String)options);
            if (!config.hasPath("options.classpath")) {
                violations.add(Violation.builder().name("Missing classpath option for GridGain 8 sink").errorDetails("Parameter options.classpath is missing").build());
            } else {
                String classpath = config.getString("options.classpath");
                if (classpath.isBlank()) {
                    violations.add(Violation.builder().name("Incorrect classpath for GridGain 8 sink").errorDetails("Parameter options.classpath is empty").build());
                }
            }
            if (!config.hasPath("options.sinkClassname")) {
                violations.add(Violation.builder().name("Missing sinkClassname option for Grid Gain 8 sink").errorDetails("Parameter options.sinkClassName is missing").build());
            } else {
                String sinkClassname = config.getString("options.sinkClassname");
                if (sinkClassname.isBlank()) {
                    violations.add(Violation.builder().name("Incorrect sinkClassname for GridGain 8 sink").errorDetails("Parameter options.sinkClassname is empty").build());
                }
            }
        }
        catch (Exception e) {
            violations.add(Violation.builder().name("Incorrect configuration for GridGain 8 sink").errorDetails(e.getMessage()).build());
            LOG.error("Incorrect configuration for GridGain 8 sink", (Throwable)e);
        }
        return violations;
    }
}

