/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api.replication;

import java.util.Objects;
import org.apache.ignite.internal.tostring.S;
import org.gridgain.internal.cdc.api.exception.CdcValidationException;
import org.gridgain.internal.cdc.api.replication.CdcReplicationExecNodes;
import org.gridgain.internal.cdc.api.replication.CdcReplicationMode;
import org.gridgain.internal.cdc.api.replication.CdcReplicationStatus;
import org.jetbrains.annotations.Nullable;

public class CdcReplicationInstance {
    private String name;
    private String sinkName;
    private String sourceName;
    private CdcReplicationMode mode;
    private CdcReplicationExecNodes executionNodes;
    private CdcReplicationStatus status;
    private String runningOnNodeId;
    @Nullable
    private String errorContext;

    public CdcReplicationInstance() {
    }

    private CdcReplicationInstance(String name, String sinkName, String sourceName, CdcReplicationMode mode, CdcReplicationExecNodes executionNodes, CdcReplicationStatus status, String runningOnNodeId, @Nullable String errorContext) {
        this.name = name;
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.mode = mode;
        this.executionNodes = executionNodes;
        this.status = status;
        this.runningOnNodeId = runningOnNodeId;
        this.errorContext = errorContext;
    }

    public String name() {
        return this.name;
    }

    public String sinkName() {
        return this.sinkName;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public CdcReplicationMode mode() {
        return this.mode;
    }

    public CdcReplicationExecNodes executionNodes() {
        return this.executionNodes;
    }

    public CdcReplicationStatus status() {
        return this.status;
    }

    public String runningOnNodeId() {
        return this.runningOnNodeId;
    }

    @Nullable
    public String errorContext() {
        return this.errorContext;
    }

    public static ReplicationInstanceBuilder builder() {
        return new ReplicationInstanceBuilder();
    }

    public ReplicationInstanceBuilder toBuilder() {
        return new ReplicationInstanceBuilder().name(this.name).sinkName(this.sinkName).sourceName(this.sourceName).mode(this.mode).executionNodes(this.executionNodes).status(this.status).runningOnNodeId(this.runningOnNodeId).errorContext(this.errorContext);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdcReplicationInstance that = (CdcReplicationInstance)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.sinkName, that.sinkName) && Objects.equals(this.sourceName, that.sourceName) && this.mode == that.mode && Objects.equals(this.executionNodes, that.executionNodes) && this.status == that.status && Objects.equals(this.runningOnNodeId, that.runningOnNodeId) && Objects.equals(this.errorContext, that.errorContext);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sinkName, this.sourceName, this.mode, this.executionNodes, this.status, this.runningOnNodeId, this.errorContext});
    }

    public String toString() {
        return S.toString((Object)this);
    }

    public static class ReplicationInstanceBuilder {
        private String name;
        private String sinkName;
        private String sourceName;
        private CdcReplicationMode mode = CdcReplicationMode.ALL;
        private CdcReplicationExecNodes executionNodes = CdcReplicationExecNodes.any();
        private CdcReplicationStatus status = CdcReplicationStatus.CREATED;
        private String runningOnNodeId;
        @Nullable
        private String errorContext;

        public ReplicationInstanceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReplicationInstanceBuilder sinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        public ReplicationInstanceBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public ReplicationInstanceBuilder mode(CdcReplicationMode mode) {
            this.mode = mode;
            return this;
        }

        public ReplicationInstanceBuilder executionNodes(CdcReplicationExecNodes executionNodes) {
            this.executionNodes = executionNodes;
            return this;
        }

        public ReplicationInstanceBuilder status(CdcReplicationStatus status) {
            this.status = status;
            return this;
        }

        public ReplicationInstanceBuilder runningOnNodeId(String runningOnNodeId) {
            this.runningOnNodeId = runningOnNodeId;
            return this;
        }

        public ReplicationInstanceBuilder errorContext(@Nullable String errorContext) {
            this.errorContext = errorContext;
            return this;
        }

        public CdcReplicationInstance build() {
            if (this.name == null || this.name.isEmpty()) {
                throw new CdcValidationException("Replication name cannot be null or empty");
            }
            if (this.sinkName == null || this.sinkName.isEmpty()) {
                throw new CdcValidationException("Sink name cannot be null or empty");
            }
            if (this.sourceName == null || this.sourceName.isEmpty()) {
                throw new CdcValidationException("Source name cannot be null or empty");
            }
            if (this.mode == null) {
                throw new CdcValidationException("Replication mode cannot be null");
            }
            if (this.executionNodes == null) {
                throw new CdcValidationException("Execution nodes cannot be null");
            }
            if (this.status == null) {
                throw new CdcValidationException("Replication status cannot be null");
            }
            return new CdcReplicationInstance(this.name, this.sinkName, this.sourceName, this.mode, this.executionNodes, this.status, this.runningOnNodeId, this.errorContext);
        }
    }
}

