/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api.source;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gridgain.internal.cdc.api.Violation;
import org.gridgain.internal.cdc.api.source.SourceDefinition;

public class SourceStatus {
    private final SourceDefinition definition;
    private final List<Violation> violations;

    private SourceStatus(SourceDefinition definition, List<Violation> violations) {
        this.definition = definition;
        this.violations = violations;
    }

    public SourceDefinition definition() {
        return this.definition;
    }

    public List<Violation> violations() {
        return this.violations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceStatus that = (SourceStatus)o;
        return Objects.equals(this.definition, that.definition) && Objects.equals(this.violations, that.violations);
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.violations);
    }

    public String toString() {
        return "SourceStatus{definition=" + String.valueOf(this.definition) + ", checks=" + String.valueOf(this.violations) + "}";
    }

    public static class Builder {
        private SourceDefinition definition;
        private List<Violation> checks;

        public Builder definition(SourceDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder checks(List<Violation> checks) {
            this.checks = checks;
            return this;
        }

        public Builder check(Violation check) {
            if (this.checks == null) {
                this.checks = new ArrayList<Violation>();
            }
            this.checks.add(check);
            return this;
        }

        public SourceStatus build() {
            Objects.requireNonNull(this.definition, "Source definition must be provided.");
            Objects.requireNonNull(this.checks, "Checks must be provided.");
            return new SourceStatus(this.definition, this.checks);
        }
    }
}

