/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api.source;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.apache.ignite.table.QualifiedName;
import org.gridgain.internal.cdc.api.source.SourceParameters;
import org.gridgain.internal.cdc.api.source.SourceTableDefinition;
import org.gridgain.internal.cdc.api.source.SourceType;
import org.jetbrains.annotations.Nullable;

public class SourceDefinition {
    private String name;
    private SourceType type;
    private SourceParameters parameters;
    private SourceTableDefinition[] tables;

    public SourceDefinition() {
    }

    private SourceDefinition(SourceType type, String name, SourceParameters parameters, SourceTableDefinition[] tables) {
        this.type = type;
        this.name = name;
        this.parameters = parameters;
        this.tables = tables == null ? new SourceTableDefinition[]{} : tables;
    }

    public static SourceDefinitionBuilder builderFrom(SourceDefinition ggSourceDefinition) {
        return new SourceDefinitionBuilder().type(ggSourceDefinition.type()).name(ggSourceDefinition.name()).parameters(ggSourceDefinition.parameters()).tables(ggSourceDefinition.tables());
    }

    public SourceType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public SourceParameters parameters() {
        return this.parameters;
    }

    public SourceTableDefinition[] tables() {
        return this.tables;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceDefinition that = (SourceDefinition)o;
        return Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.parameters, that.parameters) && Objects.deepEquals(this.tables, that.tables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.parameters, Arrays.hashCode(this.tables)});
    }

    public String toString() {
        return "SourceDefinition{name='" + this.name + "', type=" + String.valueOf((Object)this.type) + ", parameters=" + String.valueOf(this.parameters) + ", tables=" + Arrays.toString(this.tables) + "}";
    }

    public static SourceDefinitionBuilder builder() {
        return new SourceDefinitionBuilder();
    }

    public static class SourceDefinitionBuilder {
        private SourceType type;
        private String name;
        private SourceParameters parameters = new SourceParameters(new HashMap<String, Object>());
        private SourceTableDefinition[] tables = new SourceTableDefinition[0];

        public SourceDefinitionBuilder type(SourceType type) {
            this.type = type;
            return this;
        }

        public SourceDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SourceDefinitionBuilder parameters(@Nullable SourceParameters parameters) {
            if (parameters == null) {
                parameters = new SourceParameters(new HashMap<String, Object>());
            }
            this.parameters = parameters;
            return this;
        }

        public SourceDefinitionBuilder tables(SourceTableDefinition @Nullable [] tables) {
            if (tables == null) {
                tables = new SourceTableDefinition[]{};
            }
            this.tables = tables;
            return this;
        }

        public SourceDefinitionBuilder tables(String ... tables) {
            SourceTableDefinition[] tableDefs = new SourceTableDefinition[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                QualifiedName parsed = QualifiedName.parse((String)tables[i]);
                tableDefs[i] = new SourceTableDefinition(parsed.schemaName(), parsed.objectName());
            }
            this.tables = tableDefs;
            return this;
        }

        public SourceDefinition build() {
            return new SourceDefinition(this.type, this.name, this.parameters, this.tables);
        }
    }
}

