/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet.s3;

import org.apache.ignite.IgniteLogger;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.gridgain.bulkload.parquet.s3.BaseS3File;
import org.gridgain.bulkload.s3.S3InputStream;
import org.gridgain.bulkload.s3.S3URI;
import software.amazon.awssdk.services.s3.S3Client;

public class S3InputFile
extends BaseS3File
implements InputFile {
    private Long length;
    private final IgniteLogger log;

    public static S3InputFile fromLocation(String location, S3Client client, IgniteLogger log) {
        return new S3InputFile(client, new S3URI(location), null, log);
    }

    S3InputFile(S3Client client, S3URI uri, Long length, IgniteLogger log) {
        super(client, uri);
        this.length = length;
        this.log = log;
    }

    public long getLength() {
        if (this.length == null) {
            this.length = this.getObjectMetadata().contentLength();
        }
        return this.length;
    }

    public SeekableInputStream newStream() {
        return new S3InputStream(this.client(), this.uri(), this.log);
    }
}

