/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.BinaryValue;
import org.apache.parquet.example.data.simple.BooleanValue;
import org.apache.parquet.example.data.simple.DoubleValue;
import org.apache.parquet.example.data.simple.FloatValue;
import org.apache.parquet.example.data.simple.Int96Value;
import org.apache.parquet.example.data.simple.IntegerValue;
import org.apache.parquet.example.data.simple.LongValue;
import org.apache.parquet.example.data.simple.NanoTime;
import org.apache.parquet.example.data.simple.Primitive;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ObjectGroup
extends Group {
    private final GroupType schema;
    private final List<Object>[] data;

    public ObjectGroup(GroupType schema) {
        this.schema = schema;
        this.data = new List[schema.getFields().size()];
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            this.data[i] = new ArrayList<Object>();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendToString(builder, "");
        return builder.toString();
    }

    private StringBuilder appendToString(StringBuilder builder, String indent) {
        int i = 0;
        for (Type field : this.schema.getFields()) {
            String name = field.getName();
            List<Object> values = this.data[i];
            ++i;
            if (values == null || values.isEmpty()) continue;
            for (Object value : values) {
                builder.append(indent).append(name);
                if (value == null) {
                    builder.append(": NULL\n");
                    continue;
                }
                if (value instanceof Group) {
                    builder.append('\n');
                    ((ObjectGroup)((Object)value)).appendToString(builder, indent + "  ");
                    continue;
                }
                builder.append(": ").append(value.toString()).append('\n');
            }
        }
        return builder;
    }

    public Group addGroup(int fieldIndex) {
        ObjectGroup g = new ObjectGroup(this.schema.getType(fieldIndex).asGroupType());
        this.add(fieldIndex, g);
        return g;
    }

    public Group getGroup(int fieldIndex, int index) {
        return (Group)this.getValue(fieldIndex, index);
    }

    public Object getValue(int fieldIndex, int index) {
        if (fieldIndex >= this.data.length) {
            return null;
        }
        List<Object> list = this.data[fieldIndex];
        if (index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    private void add(int fieldIndex, Primitive value) {
        Type type = this.schema.getType(fieldIndex);
        List<Object> list = this.data[fieldIndex];
        if (!type.isRepetition(Type.Repetition.REPEATED) && !list.isEmpty()) {
            throw new IllegalStateException("field " + fieldIndex + " (" + type.getName() + ") can not have more than one value: " + list);
        }
        list.add(value);
    }

    public int getFieldRepetitionCount(int fieldIndex) {
        List<Object> list = this.data[fieldIndex];
        return list == null ? 0 : list.size();
    }

    public String getValueToString(int fieldIndex, int index) {
        return String.valueOf(this.getValue(fieldIndex, index));
    }

    public String getString(int fieldIndex, int index) {
        return ((BinaryValue)this.getValue(fieldIndex, index)).getString();
    }

    public int getInteger(int fieldIndex, int index) {
        return ((IntegerValue)this.getValue(fieldIndex, index)).getInteger();
    }

    public long getLong(int fieldIndex, int index) {
        return ((LongValue)this.getValue(fieldIndex, index)).getLong();
    }

    public double getDouble(int fieldIndex, int index) {
        return ((DoubleValue)this.getValue(fieldIndex, index)).getDouble();
    }

    public float getFloat(int fieldIndex, int index) {
        return ((FloatValue)this.getValue(fieldIndex, index)).getFloat();
    }

    public boolean getBoolean(int fieldIndex, int index) {
        return ((BooleanValue)this.getValue(fieldIndex, index)).getBoolean();
    }

    public Binary getBinary(int fieldIndex, int index) {
        return ((BinaryValue)this.getValue(fieldIndex, index)).getBinary();
    }

    public Binary getInt96(int fieldIndex, int index) {
        return ((Int96Value)this.getValue(fieldIndex, index)).getInt96();
    }

    public void add(int fieldIndex, int value) {
        this.add(fieldIndex, (Primitive)new IntegerValue(value));
    }

    public void add(int fieldIndex, long value) {
        this.add(fieldIndex, (Primitive)new LongValue(value));
    }

    public void add(int fieldIndex, String value) {
        this.add(fieldIndex, (Primitive)new BinaryValue(Binary.fromString((String)value)));
    }

    public void add(int fieldIndex, NanoTime value) {
        this.add(fieldIndex, (Primitive)value.toInt96());
    }

    public void add(int fieldIndex, boolean value) {
        this.add(fieldIndex, (Primitive)new BooleanValue(value));
    }

    public void add(int fieldIndex, Binary value) {
        PrimitiveType type = this.getType().getType(fieldIndex).asPrimitiveType();
        switch (type.getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                this.add(fieldIndex, (Primitive)new BinaryValue(value));
                break;
            }
            case INT96: {
                this.add(fieldIndex, (Primitive)new Int96Value(value));
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.getType().asPrimitiveType().getName() + " not supported for Binary");
            }
        }
    }

    public void add(int fieldIndex, float value) {
        this.add(fieldIndex, (Primitive)new FloatValue(value));
    }

    public void add(int fieldIndex, double value) {
        this.add(fieldIndex, (Primitive)new DoubleValue(value));
    }

    public void add(int fieldIndex, Group value) {
        this.data[fieldIndex].add(value);
    }

    public GroupType getType() {
        return this.schema;
    }

    public void writeValue(int field, int index, RecordConsumer recordConsumer) {
        ((Primitive)this.getValue(field, index)).writeValue(recordConsumer);
    }
}

