/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.BulkLoadParquetAbstractTest;
import org.junit.Test;

public class BulkLoadParquetTest
extends BulkLoadParquetAbstractTest {
    private static final String BULKLOAD_ALL_FIELDS = "parquet/all_fields_data.parquet";
    private static final String BULKLOAD_ALL_FIELDS_ROWS_PER_GROUP_100 = "parquet/all_fields_rows_per_group_100.parquet";
    private static final String BULKLOAD_ALL_FIELDS_2K = "parquet/all_fields_2k.parquet";
    private static final String BULKLOAD_ALL_FIELDS_2K_EXPECTED = "parquet/all_fields_2k_expected.csv";
    private static final String BULKLOAD_ALL_FIELDS_EXPECTED = "parquet/all_fields_data_expected.csv";
    private static final String BULKLOAD_ALL_FIELDS_COMPRESSED = "parquet/all_fields_compressed.parquet";
    private static final String BULKLOAD_ALL_FIELDS_PARTITIONED = "parquet/all_fields_partitioned_table";
    private static final String BULKLOAD_ALL_FIELDS_PARTITIONED_EXPECTED = "parquet/all_fields_partitioned_expected.csv";
    private static final String BULKLOAD_PARTITIONED_CORRUPTED = "parquet/partitioned_corrupted";
    private static final String BULKLOAD_INVALID_PARQUET = "parquet/not_a_parquet_file.parquet";
    private static final String BULKLOAD_PARQUET_CORRUPTED = "parquet/corrupted.parquet";
    private static final String BULKLOAD_DIFFERENT_SCHEMAS = "parquet/different_schemas";
    private static final String BULKLOAD_TIMESTAMPS = "parquet/timestamps.parquet";
    private static final String BULKLOAD_UUID = "parquet/data_uuid.parquet";
    private static final String BULKLOAD_UUID_EXPECTED = "parquet/data_uuid_expected.csv";
    private static final String BULKLOAD_BINARY = "parquet/data_binary.parquet";
    private static final String BULKLOAD_BINARY_EXPECTED = "parquet/data_binary_expected.csv";

    @Test
    public void basicTest() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_ALL_FIELDS).into(TBL).toString());
        BulkLoadParquetTest.assertEquals((int)10, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", BULKLOAD_ALL_FIELDS_EXPECTED);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from(TBL).intoTemp().toString());
        BulkLoadParquetTest.assertEquals((int)10, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", TBL_COLUMNS, this.readValuesFromParquetFile(this.temp, (List<String>)TBL_COLUMNS));
    }

    @Test
    public void timestampsTest() throws Exception {
        List<String> cols = Arrays.asList("id", "timestamp_millis", "timestamp_micros");
        this.stmt.executeUpdate("CREATE TABLE timestamps (id INT, timestamp_millis TIMESTAMP, timestamp_micros TIMESTAMP, PRIMARY KEY (id) );");
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().into("timestamps(id, timestamp_millis, timestamp_micros)").fromResource(BULKLOAD_TIMESTAMPS).toString());
        BulkLoadParquetTest.assertEquals((int)1, (int)updatesCnt);
        this.checkCacheContents("timestamps", cols, this.readValuesFromParquetFile(BulkLoadParquetTest.resolveAbsolutePath(BULKLOAD_TIMESTAMPS), cols));
    }

    @Test
    public void basic2kTest() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_ALL_FIELDS_2K).into(TBL).toString());
        BulkLoadParquetTest.assertEquals((int)2000, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", BULKLOAD_ALL_FIELDS_2K_EXPECTED);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from(TBL).intoTemp().toString());
        BulkLoadParquetTest.assertEquals((int)2000, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", TBL_COLUMNS, this.readValuesFromParquetFile(this.temp, (List<String>)TBL_COLUMNS));
    }

    @Test
    public void basicRowsPerGroup100Test() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_ALL_FIELDS_ROWS_PER_GROUP_100).into(TBL).toString());
        BulkLoadParquetTest.assertEquals((int)2000, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", BULKLOAD_ALL_FIELDS_2K_EXPECTED);
    }

    @Test
    public void compressedTest() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_ALL_FIELDS_COMPRESSED).into(TBL).toString());
        BulkLoadParquetTest.assertEquals((int)10, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", BULKLOAD_ALL_FIELDS_EXPECTED);
    }

    @Test
    public void partitionedTableTest() throws Exception {
        ArrayList<String> columns = new ArrayList<String>(TBL_COLUMNS);
        columns.remove("married");
        String tbl = "PersonExtended(" + String.join((CharSequence)",", columns) + ")";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_ALL_FIELDS_PARTITIONED).pattern(".*").into(tbl).toString());
        BulkLoadParquetTest.assertEquals((int)10, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", BULKLOAD_ALL_FIELDS_PARTITIONED_EXPECTED, columns);
    }

    @Test
    public void nullValuesTest() throws Exception {
        this.stmt.execute("insert into " + TBL + " values (1, null, null, null, null, null, null, null)");
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from(TBL).intoTemp().toString());
        BulkLoadParquetTest.assertEquals((int)1, (int)updatesCnt);
        this.stmt.execute("delete from PersonExtended");
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromTemp().into(TBL).toString());
        BulkLoadParquetTest.assertEquals((int)1, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", TBL_COLUMNS, this.readValuesFromParquetFile(this.temp, (List<String>)TBL_COLUMNS));
    }

    @Test
    public void partitionedCorrupted() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_PARTITIONED_CORRUPTED).pattern(".*").into(TBL).toString()), SQLException.class, (String)"can not read");
    }

    @Test
    public void wrongBinaryFileTest() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_INVALID_PARQUET).pattern(".*").into(TBL).toString()), SQLException.class, (String)"is not a Parquet file");
    }

    @Test
    public void corruptedFileTest() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_PARQUET_CORRUPTED).pattern(".*").into(TBL).toString()), SQLException.class, (String)"can not read");
    }

    @Test
    public void differentSchemasTest() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_DIFFERENT_SCHEMAS).pattern(".*").into(TBL).toString()), SQLException.class, (String)"All parquet files must have the same schema");
    }

    @Test
    public void notAFileTest() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_DIFFERENT_SCHEMAS).into(TBL).toString()), SQLException.class, (String)"Failed to");
        this.stmt.executeUpdate("insert into " + TBL + " values (1, null, null, null, null, null, null, null)");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from(TBL).into("'" + BulkLoadParquetTest.resolveAbsolutePath(BULKLOAD_DIFFERENT_SCHEMAS) + "'").toString()), SQLException.class, (String)"Failed to");
    }

    @Test
    public void uuidTest() throws Exception {
        List<String> cols = Arrays.asList("id", "name");
        this.stmt.executeUpdate("CREATE TABLE uuidTest (id UUID, name VARCHAR, PRIMARY KEY (id) );");
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().into("uuidTest(id, name)").fromResource(BULKLOAD_UUID).toString());
        BulkLoadParquetTest.assertEquals((int)1, (int)updatesCnt);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("uuidTest(id, name)").intoTemp().toString());
        BulkLoadParquetTest.assertEquals((int)1, (int)updatesCnt);
        this.checkCacheContents("uuidTest", BULKLOAD_UUID_EXPECTED, cols);
        this.checkCacheContents("uuidTest", cols, this.readValuesFromParquetFile(BulkLoadParquetTest.resolveAbsolutePath(BULKLOAD_UUID), cols));
    }

    @Test
    public void binaryTest() throws Exception {
        List<String> cols = Arrays.asList("id", "bin");
        this.stmt.executeUpdate("CREATE TABLE binaryTest (id int, bin BINARY, PRIMARY KEY (id) );");
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().into("binaryTest(id, bin)").fromResource(BULKLOAD_BINARY).toString());
        BulkLoadParquetTest.assertEquals((int)1, (int)updatesCnt);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("binaryTest(id, bin)").intoTemp().toString());
        BulkLoadParquetTest.assertEquals((int)1, (int)updatesCnt);
        this.checkCacheContents("binaryTest", BULKLOAD_BINARY_EXPECTED, cols);
        this.checkCacheContents("binaryTest", cols, this.readValuesFromParquetFile(BulkLoadParquetTest.resolveAbsolutePath(BULKLOAD_BINARY), cols));
    }

    @Test
    public void pathDoesntExist() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("'Not existing path'").into(TBL).toString()), SQLException.class, (String)"Failed to read file");
    }

    @Test
    public void patternFiltersOutEverything() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("'Not existing path'").pattern("filter everything").into(TBL).toString()), SQLException.class, (String)"No files to read from matching pattern");
    }
}

