/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.query.h2.H2SqlFieldMetadata;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.iceberg.IcebergUtils;
import org.gridgain.bulkload.iceberg.IcebergWriter;
import org.gridgain.bulkload.model.PersonExtended;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Test;

public class BulkLoadIcebergTest
extends BulkLoadAbstractTest {
    protected static final String TBL_NAME = "PersonExtended";
    protected static final String TBL_COLS = " (_key, id, firstName, lastName, birthdate, registered, married, children, averageSalary)";
    protected static final List<String> TBL_COLS_EXTENDED = Arrays.asList("_key", "id", "booleanColumn", "longColumn", "bigDecimalColumn", "doubleColumn", "integerColumn", "floatColumn", "shortColumn", "byteColumn", "stringColumn", "dateColumn", "timeColumn", "timestampColumn", "binaryColumn", "uuidColumn");
    protected static final String TBL_EXTENDED = "PersonExtended(" + String.join((CharSequence)",", TBL_COLS_EXTENDED) + ")";
    protected static final String TBL = "PersonExtended (_key, id, firstName, lastName, birthdate, registered, married, children, averageSalary)";
    protected static final String CATALOG_IMPL = "org.apache.iceberg.hadoop.HadoopCatalog";

    @Override
    protected String getFormatDefault() {
        return "ICEBERG PROPERTIES ('table-identifier'='PersonExtended', 'catalog-impl'='org.apache.iceberg.hadoop.HadoopCatalog') ";
    }

    @Test
    public void testBasic() throws Exception {
        HashMap<Long, PersonExtended> expected = new HashMap<Long, PersonExtended>();
        expected.put(1L, BulkLoadIcebergTest.newPerson(1L, "basic"));
        expected.put(2L, BulkLoadIcebergTest.newPersonEmpty(2L));
        IgniteCache cache = this.ignite(0).getOrCreateCache(this.cacheConfig());
        cache.putAll(expected);
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).intoTempDir().toString());
        BulkLoadIcebergTest.assertEquals((int)2, (int)updatesCnt);
        this.readIcebergTable(this.tempDir, TBL_NAME);
        cache.clear();
        BulkLoadIcebergTest.assertNull((Object)cache.get((Object)1L));
        BulkLoadIcebergTest.assertNull((Object)cache.get((Object)2L));
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromTempDir().into(TBL).toString());
        BulkLoadIcebergTest.assertEquals((int)2, (int)updatesCnt);
        BulkLoadIcebergTest.assertEquals(expected.get(1L), (Object)cache.get((Object)1L));
        BulkLoadIcebergTest.assertEquals(expected.get(2L), (Object)cache.get((Object)2L));
    }

    @Test
    public void testDoesntExist() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromTempDir().into(TBL).toString()), SQLException.class, (String)"Table does not exist: PersonExtended");
    }

    @Test
    public void testCopyWithoutProperties() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).intoTempDir().format("ICEBERG").toString()), SQLException.class, (String)"Cannot initialize Catalog implementation");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromTempDir().into(TBL).format("ICEBERG PROPERTIES('catalog-impl'='org.apache.iceberg.hadoop.HadoopCatalog')").toString()), SQLException.class, (String)"Cannot load iceberg table, 'table-identifier' property is null (ex.: 'db.schema.tbl' or 'tbl')");
    }

    @Test
    public void testTypes() throws Exception {
        HashMap<Long, PersonExtended> expected = new HashMap<Long, PersonExtended>();
        expected.put(1L, BulkLoadIcebergTest.newPerson(1L, "test-types"));
        expected.put(2L, BulkLoadIcebergTest.newPersonEmpty(2L));
        IgniteCache cache = this.ignite(0).getOrCreateCache(this.cacheConfig());
        cache.putAll(expected);
        this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL_EXTENDED).intoTempDir().toString());
        Table icebergTable = BulkLoadIcebergTest.loadIcebergTable(this.tempDir, TBL_NAME);
        for (String col : TBL_COLS_EXTENDED) {
            if ("_key".equals(col)) continue;
            List<?> actual = this.readIcebergTableColumn(icebergTable, col);
            Object[] expectedItems = BulkLoadIcebergTest.asIcebergValues(expected, col);
            Assert.assertThat(actual, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expectedItems));
        }
        cache.clear();
        BulkLoadIcebergTest.assertNull((Object)cache.get((Object)1L));
        BulkLoadIcebergTest.assertNull((Object)cache.get((Object)2L));
        this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromTempDir().into(TBL_EXTENDED).toString());
        BulkLoadIcebergTest.assertColumnsEquals(TBL_COLS_EXTENDED, expected, (IgniteCache<Long, PersonExtended>)cache);
    }

    @Test
    public void testTypesNotSupported() throws Exception {
        String column = "geometryColumn";
        String tblNameGeo = "PersonExtended(" + column + ")";
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(tblNameGeo).intoTempDir().toString()), SQLException.class, (String)"Cannot parse type string to primitive: Geometry");
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("_key", 1L);
        row.put("shortColumn", Integer.MAX_VALUE);
        row.put("byteColumn", Integer.MAX_VALUE);
        this.writeIcebergTable(this.tempDir, TBL_NAME, row);
        column = "shortColumn";
        String tblNameShort = "PersonExtended(_key, " + column + ")";
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromTempDir().into(tblNameShort).toString()), SQLException.class, (String)"Value conversion failed [column=SHORTCOLUMN, from=java.lang.Integer, to=java.lang.Short]");
        column = "byteColumn";
        String tblNameByte = "PersonExtended(_key, " + column + ")";
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromTempDir().into(tblNameByte).toString()), SQLException.class, (String)"Value conversion failed [column=BYTECOLUMN, from=java.lang.Integer, to=java.lang.Byte]");
    }

    protected static void assertColumnsEquals(List<String> columns, Map<Long, PersonExtended> expected, IgniteCache<Long, PersonExtended> cache) {
        for (String col : columns) {
            if ("_key".equals(col)) continue;
            if ("bigDecimalColumn".equals(col)) {
                BulkLoadIcebergTest.assertEquals((Object)IcebergUtils.asIcebergValue((Object)expected.get(1L).getField(col)), (Object)((PersonExtended)cache.get((Object)1L)).getField(col));
                BulkLoadIcebergTest.assertEquals((Object)IcebergUtils.asIcebergValue((Object)expected.get(2L).getField(col)), (Object)((PersonExtended)cache.get((Object)2L)).getField(col));
                continue;
            }
            if ("binaryColumn".equals(col)) {
                Assert.assertArrayEquals((byte[])((byte[])expected.get(1L).getField(col)), (byte[])((byte[])((PersonExtended)cache.get((Object)1L)).getField(col)));
                Assert.assertArrayEquals((byte[])((byte[])expected.get(2L).getField(col)), (byte[])((byte[])((PersonExtended)cache.get((Object)2L)).getField(col)));
                continue;
            }
            BulkLoadIcebergTest.assertEquals((Object)expected.get(1L).getField(col), (Object)((PersonExtended)cache.get((Object)1L)).getField(col));
            BulkLoadIcebergTest.assertEquals((Object)expected.get(2L).getField(col), (Object)((PersonExtended)cache.get((Object)2L)).getField(col));
        }
    }

    protected void readIcebergTable(File whLocation, String tableIdentifier) throws Exception {
        Table table = BulkLoadIcebergTest.loadIcebergTable(whLocation, tableIdentifier);
        try (CloseableIterable records = IcebergGenerics.read((Table)table).build();){
            for (Record r : records) {
                System.out.println(r);
            }
        }
    }

    protected List<?> readIcebergTableColumn(Table table, String columnName) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        try (CloseableIterable records = IcebergGenerics.read((Table)table).build();){
            for (Record r : records) {
                Object value = r.getField(columnName.toUpperCase());
                result.add(value);
            }
        }
        return result;
    }

    protected static Table loadIcebergTable(File whLocation, String tableIdentifier) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("warehouse", whLocation.toPath().toAbsolutePath().toString());
        Catalog catalog = CatalogUtil.loadCatalog((String)CATALOG_IMPL, (String)CATALOG_IMPL, properties, (Object)new Configuration());
        TableIdentifier name = TableIdentifier.of((String[])tableIdentifier.split("[.,]"));
        return catalog.loadTable(name);
    }

    protected void writeIcebergTable(File whLocation, String tableIdentifier, Map<String, Object> row) throws Exception {
        if (GridFunc.isEmpty(row)) {
            throw new IllegalArgumentException("Can not write empty row");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("warehouse", whLocation.getAbsolutePath());
        properties.put("catalog-impl", CATALOG_IMPL);
        properties.put("table-identifier", tableIdentifier);
        ArrayList<FieldMetadataTest> fieldsMeta = new ArrayList<FieldMetadataTest>();
        ArrayList<Object> rowValues = new ArrayList<Object>();
        for (Map.Entry<String, Object> e : row.entrySet()) {
            FieldMetadataTest m = new FieldMetadataTest(e.getKey(), e.getValue().getClass());
            fieldsMeta.add(m);
            rowValues.add(e.getValue());
        }
        ArrayList<ArrayList<Object>> rows = new ArrayList<ArrayList<Object>>();
        rows.add(rowValues);
        try (IcebergWriter writer = new IcebergWriter(new BulkLoadLocationFile(), properties, fieldsMeta);){
            writer.writeAll(rows);
        }
    }

    protected void deleteIcebergTable(File whLocation, String tableIdentifier) throws Exception {
        FileUtils.deleteDirectory((File)whLocation.toPath().resolve(tableIdentifier).toFile());
    }

    protected static Object[] asIcebergValues(Map<Long, PersonExtended> data, String columnName) {
        return data.values().stream().map(v -> IcebergUtils.asIcebergValue((Object)v.getField(columnName))).toArray();
    }

    protected static class FieldMetadataTest
    extends H2SqlFieldMetadata {
        private Class<?> fieldTypeName;
        private String fieldName;

        public FieldMetadataTest(String fieldName, Class<?> fieldTypeName) {
            this.fieldName = fieldName.toUpperCase();
            this.fieldTypeName = fieldTypeName;
        }

        public FieldMetadataTest() {
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String fieldTypeName() {
            return this.fieldTypeName.getName();
        }

        public int nullability() {
            return 1;
        }
    }
}

