/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;

public class LocalOutputFile
implements OutputFile {
    private final Path path;

    public LocalOutputFile(Path file) {
        this.path = file;
    }

    public PositionOutputStream create(long buffer) throws IOException {
        return new LocalPositionOutputStream((int)buffer, StandardOpenOption.CREATE_NEW);
    }

    public PositionOutputStream createOrOverwrite(long buffer) throws IOException {
        return new LocalPositionOutputStream((int)buffer, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public boolean supportsBlockSize() {
        return true;
    }

    public long defaultBlockSize() {
        return 512L;
    }

    public String getPath() {
        return this.path.toString();
    }

    private class LocalPositionOutputStream
    extends PositionOutputStream {
        private final BufferedOutputStream stream;
        private long pos = 0L;

        public LocalPositionOutputStream(int buffer, StandardOpenOption ... openOption) throws IOException {
            this.stream = new BufferedOutputStream(Files.newOutputStream(LocalOutputFile.this.path, openOption), buffer);
        }

        public long getPos() {
            return this.pos;
        }

        public void write(int data) throws IOException {
            ++this.pos;
            this.stream.write(data);
        }

        public void write(byte[] data) throws IOException {
            this.pos += (long)data.length;
            this.stream.write(data);
        }

        public void write(byte[] data, int off, int len) throws IOException {
            this.pos += (long)len;
            this.stream.write(data, off, len);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void close() throws IOException {
            this.stream.close();
        }
    }
}

