/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetIoPublic;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Types;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParquetFormat;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.parquet.Strings;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.schema.MessageType;
import org.gridgain.bulkload.iceberg.IcebergUtils;
import org.gridgain.bulkload.io.Reader;
import org.gridgain.bulkload.s3.S3ClientFactory;
import org.gridgain.bulkload.s3.S3Utils;
import org.gridgain.bulkload.util.PathUtils;
import software.amazon.awssdk.services.s3.S3Client;

public class IcebergParquetReader
implements Reader {
    private final IgniteLogger log;
    private final CloseableGroup closeableGroup;
    private final Iterator<Record> iterator;
    private final List<String> columns;

    public IcebergParquetReader(BulkLoadLocationFile from, BulkLoadParquetFormat fmt, List<String> columns, Map<String, String> properties, IgniteLogger log) throws IOException {
        this.log = log;
        List<InputFile> inputFiles = this.getInputFilesFromPattern(from.path(), fmt.pattern(), IcebergUtils.combineProperties(from, properties));
        if (inputFiles.isEmpty()) {
            throw new IOException("No files to read from matching pattern: '" + fmt.pattern() + "'");
        }
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.setSuppressCloseFailure(true);
        MessageType parquetSchema = this.getParquetSchema(inputFiles.get(0));
        if (!this.validateSchemas(inputFiles, parquetSchema)) {
            throw new IOException("All parquet files must have the same schema");
        }
        Schema schema = ParquetSchemaUtil.convert((MessageType)parquetSchema);
        this.columns = columns.stream().map(col -> {
            Types.NestedField nf = schema.caseInsensitiveFindField(col);
            if (nf == null) {
                log.warning("Column '" + col + "' not found in parquet schema, values will be null");
                return null;
            }
            return nf.name();
        }).collect(Collectors.toList());
        this.iterator = this.addCloseable(CloseableIterable.concat((Iterable)inputFiles.stream().map(inputFile -> Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).caseInsensitive().build()).collect(Collectors.toList()))).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public List<List<?>> nextBatch(int batchSize) throws IOException {
        ArrayList res = new ArrayList();
        for (int i = 0; i < batchSize && this.iterator.hasNext(); ++i) {
            res.add(IcebergUtils.asList(this.iterator.next(), this.columns));
        }
        return res;
    }

    @Override
    public List<GridQueryFieldMetadata> fieldsMeta() {
        return Collections.emptyList();
    }

    @Override
    public void close() throws Exception {
        this.closeableGroup.close();
    }

    private <T extends Closeable> T addCloseable(T closeable) {
        this.closeableGroup.addCloseable(closeable);
        return closeable;
    }

    private MessageType getParquetSchema(InputFile file) throws IOException {
        ParquetFileReader schemaReader = this.addCloseable(ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIoPublic.file(file)));
        return schemaReader.getFileMetaData().getSchema();
    }

    private boolean validateSchemas(List<InputFile> files, MessageType schema) throws IOException {
        if (files.size() == 1) {
            return true;
        }
        for (InputFile file : files) {
            MessageType parquetSchema = this.getParquetSchema(file);
            if (parquetSchema.equals((Object)schema)) continue;
            return false;
        }
        return true;
    }

    private List<InputFile> getInputFilesFromPattern(String path, String pattern, Map<String, String> properties) throws IOException {
        if (Strings.isNullOrEmpty((String)pattern)) {
            if (S3Utils.isS3Scheme(path)) {
                return Collections.singletonList(S3InputFile.fromLocation((String)path, (S3Client)S3ClientFactory.createS3Client(properties), (S3FileIOProperties)new S3FileIOProperties(), (MetricsContext)MetricsContext.nullMetrics()));
            }
            return Collections.singletonList(Files.localInput((File)Paths.get(path, new String[0]).toFile()));
        }
        List<Path> matchedFiles = PathUtils.getFilesByPattern(path, pattern);
        return matchedFiles.stream().map(Path::toFile).map(Files::localInput).collect(Collectors.toList());
    }
}

