/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.iceberg;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.gridgain.bulkload.iceberg.IcebergUtils;
import org.gridgain.bulkload.io.Reader;

public class IcebergReader
implements Reader {
    private final CloseableGroup closeableGroup;
    private final CloseableIterator<Record> iterator;

    public IcebergReader(BulkLoadLocationFile location, Map<String, String> properties) {
        Map<String, String> props = IcebergUtils.combineProperties(location, properties);
        String impl = props.get("catalog-impl");
        String tableIdentifier = props.get("table-identifier");
        if (tableIdentifier == null || tableIdentifier.isEmpty()) {
            throw new IllegalArgumentException("Cannot load iceberg table, 'table-identifier' property is null (ex.: 'db.schema.tbl' or 'tbl')");
        }
        TableIdentifier name = TableIdentifier.of((String[])tableIdentifier.split("[./\\\\]"));
        Catalog catalog = CatalogUtil.loadCatalog((String)impl, (String)impl, props, (Object)IcebergUtils.combineConfiguration(props));
        Table table = catalog.loadTable(name);
        CloseableIterable records = IcebergGenerics.read((Table)table).build();
        this.iterator = records.iterator();
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.setSuppressCloseFailure(true);
        if (catalog instanceof Closeable) {
            this.closeableGroup.addCloseable((Closeable)catalog);
        }
        this.closeableGroup.addCloseable((Closeable)records);
        this.closeableGroup.addCloseable(this.iterator);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<List<?>> nextBatch(int batchSize) throws IOException {
        ArrayList res = new ArrayList();
        for (int i = 0; i < batchSize && this.iterator.hasNext(); ++i) {
            res.add(IcebergUtils.asList((Record)this.iterator.next()));
        }
        return res;
    }

    @Override
    public void close() throws Exception {
        this.closeableGroup.close();
    }

    @Override
    public List<GridQueryFieldMetadata> fieldsMeta() {
        return Collections.emptyList();
    }
}

