/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.ICSVWriter;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCsvFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.gridgain.bulkload.io.Writer;
import org.gridgain.bulkload.s3.S3ClientFactory;
import org.gridgain.bulkload.s3.S3Utils;

public class CsvWriter
implements Writer {
    private final IgniteLogger log;
    private final ICSVWriter writer;
    private final List<GridQueryFieldMetadata> columns;
    private boolean header;

    public CsvWriter(BulkLoadLocationFile into, BulkLoadCsvFormat fmt, Map<String, String> properties, List<GridQueryFieldMetadata> columns, IgniteLogger log) throws IOException {
        CSVParser csvParser = new CSVParserBuilder().withSeparator(fmt.fieldSeparator().charAt(0)).withFieldAsNull(CSVReaderNullFieldIndicator.BOTH).build();
        Charset charset = Charset.forName(fmt.inputCharsetName());
        this.header = fmt.header();
        this.columns = columns;
        this.writer = new CSVWriterBuilder(this.getWriterForPath(into.path(), charset, properties)).withParser((ICSVParser)csvParser).build();
        this.log = log;
    }

    private java.io.Writer getWriterForPath(String path, Charset charset, Map<String, String> properties) throws IOException {
        if (S3Utils.isS3Scheme(path)) {
            return S3ClientFactory.getOutputStreamWriter(path, properties, this.log);
        }
        return Files.newBufferedWriter(Paths.get(path, new String[0]), charset, new OpenOption[0]);
    }

    @Override
    public void writeAll(List<List<?>> batch) {
        if (this.header) {
            this.writer.writeAll(this.toStringLines(this.toColumnNames(this.columns)), false);
            this.header = false;
        }
        this.writer.writeAll(this.toStringLines(batch), false);
    }

    private List<String[]> toStringLines(List<List<?>> batch) {
        ArrayList<String[]> result = new ArrayList<String[]>(batch.size());
        for (List<?> objects : batch) {
            String[] arr = new String[objects.size()];
            for (int i = 0; i < objects.size(); ++i) {
                arr[i] = objects.get(i) == null ? null : objects.get(i).toString();
            }
            result.add(arr);
        }
        return result;
    }

    private List<List<?>> toColumnNames(List<GridQueryFieldMetadata> columns) {
        ArrayList<String> columnNames = new ArrayList<String>(columns.size());
        for (GridQueryFieldMetadata column : columns) {
            String name = column.fieldName();
            columnNames.add(name);
        }
        return Arrays.asList(columnNames);
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

