/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import com.opencsv.exceptions.CsvValidationException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCsvFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.gridgain.bulkload.io.Reader;
import org.gridgain.bulkload.s3.S3ClientFactory;
import org.gridgain.bulkload.s3.S3Utils;

public class CsvReader
implements Reader {
    private final CSVReader reader;
    private Iterator<String[]> iterator;
    private final BulkLoadCsvFormat fmt;
    private final Map<Integer, Integer> columnsMapping;
    private final IgniteLogger log;

    public CsvReader(BulkLoadLocationFile from, BulkLoadCsvFormat fmt, Map<String, String> properties, List<String> columns, IgniteLogger log) throws IOException {
        this.fmt = fmt;
        this.log = log;
        CSVParser csvParser = new CSVParserBuilder().withSeparator(fmt.fieldSeparator().charAt(0)).withFieldAsNull(CSVReaderNullFieldIndicator.BOTH).build();
        Charset charset = Charset.forName(fmt.inputCharsetName());
        this.reader = new CSVReaderBuilder(this.getReaderForPath(from.path(), charset, properties)).withCSVParser((ICSVParser)csvParser).build();
        try {
            this.columnsMapping = this.createColumnsMapping(fmt.header(), columns);
            this.iterator = this.reader.iterator();
        }
        catch (Exception ex) {
            this.reader.close();
            throw new IOException("Failed to read CSV file '" + from.path() + "': " + ex.getMessage(), ex);
        }
    }

    private java.io.Reader getReaderForPath(String path, Charset charset, Map<String, String> properties) throws IOException {
        if (S3Utils.isS3Scheme(path)) {
            return S3ClientFactory.getInputStreamReader(path, properties, this.log);
        }
        return Files.newBufferedReader(Paths.get(path, new String[0]), charset);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<List<?>> nextBatch(int batchSize) throws IOException {
        try {
            ArrayList res = new ArrayList();
            for (int i = 0; i < batchSize; ++i) {
                if (!this.iterator.hasNext()) {
                    return res;
                }
                res.add(Arrays.asList(this.processRow(this.mapColumns(this.iterator.next()))));
            }
            return res;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private String[] mapColumns(String[] row) {
        String[] newRow = new String[this.columnsMapping.size()];
        for (int i = 0; i < this.columnsMapping.size(); ++i) {
            newRow[i] = row[this.columnsMapping.get(i)];
        }
        return newRow;
    }

    private Map<Integer, Integer> createColumnsMapping(boolean header, List<String> columns) throws IOException, CsvValidationException {
        HashMap<Integer, Integer> columnsMapping = new HashMap<Integer, Integer>();
        if (header) {
            String[] headerRow = this.reader.readNext();
            for (int i = 0; i < columns.size(); ++i) {
                String column = columns.get(i);
                for (int j = 0; j < headerRow.length; ++j) {
                    if (!column.equalsIgnoreCase(headerRow[j])) continue;
                    columnsMapping.put(i, j);
                }
            }
        } else {
            for (int i = 0; i < columns.size(); ++i) {
                columnsMapping.put(i, i);
            }
        }
        return Collections.unmodifiableMap(columnsMapping);
    }

    private String[] processRow(String[] row) {
        if (this.fmt.nullString() != null) {
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == null) continue;
                row[i] = this.processTrim(row[i]);
                row[i] = this.processNullString(row[i]);
            }
        }
        return row;
    }

    private String processNullString(String val) {
        if (this.fmt.nullString().equals(val)) {
            return null;
        }
        return val;
    }

    private String processTrim(String val) {
        if (this.fmt.trim()) {
            return val.trim();
        }
        return val;
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }

    @Override
    public List<GridQueryFieldMetadata> fieldsMeta() {
        return Collections.emptyList();
    }
}

