/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCacheWriter;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationTable;
import org.apache.ignite.internal.processors.bulkload.BulkLoadStreamerWriter;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.dml.DmlBulkLoadDataConverter;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.bulkload.io.Writer;

public class CacheWriter
implements Writer {
    private final IgniteClosureX<List<?>, IgniteBiTuple<?, ?>> dataConverter;
    private final BulkLoadCacheWriter outputWriter;
    private final UpdatePlan plan;

    public CacheWriter(GridKernalContext ctx, BulkLoadLocationTable into) throws IgniteCheckedException {
        SchemaManager mgr = ((IgniteH2Indexing)ctx.query().getIndexing()).schemaManager();
        GridH2Table tbl = mgr.dataTable(into.schemaName(), into.tableName());
        if (tbl == null) {
            throw new IgniteSQLException("Table does not exist: " + into.tableName(), 3001);
        }
        H2Utils.checkAndStartNotStartedCache((GridKernalContext)ctx, (GridH2Table)tbl);
        this.plan = UpdatePlanBuilder.planForBulkLoad((List)into.columns(), (GridH2Table)tbl);
        this.dataConverter = new DmlBulkLoadDataConverter(this.plan);
        this.outputWriter = new BulkLoadStreamerWriter(ctx.grid().dataStreamer(tbl.cacheName()));
    }

    @Override
    public void writeAll(List<List<?>> batch) {
        for (List<?> record : batch) {
            IgniteBiTuple kv = (IgniteBiTuple)this.dataConverter.apply(record);
            this.outputWriter.apply((Object)kv);
        }
    }

    @Override
    public void close() throws Exception {
        this.outputWriter.close();
    }
}

