/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.model;

import java.io.Serializable;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.internal.util.typedef.F;

public class Person
implements Serializable {
    @QuerySqlField
    private final int id;
    @QuerySqlField
    private final String firstName;
    @QuerySqlField
    private final String lastName;
    @QuerySqlField
    private final int age;

    Person(int id, String firstName, String lastName, int age) {
        assert (!F.isEmpty((String)firstName));
        assert (!F.isEmpty((String)lastName));
        assert (age > 0);
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.age = age;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.id != person.id) {
            return false;
        }
        if (this.age != person.age) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(person.firstName) : person.firstName != null) {
            return false;
        }
        return this.lastName != null ? this.lastName.equals(person.lastName) : person.lastName == null;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 31 * result + this.age;
        return result;
    }
}

