/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WhenSqlSchemaNotSetTest
extends BulkLoadAbstractTest {
    private static final String TBL = "Person (_key, age, firstName, lastName)";
    @Parameterized.Parameter
    public String format;

    @Override
    protected String getFormatDefault() {
        return this.format;
    }

    @Override
    protected CacheConfiguration cacheConfig() {
        return super.cacheConfig().setSqlSchema(null);
    }

    @Parameterized.Parameters(name="format={0}")
    public static Collection<String> getFormatParameters() {
        return Arrays.asList("csv", "parquet");
    }

    @Test
    public void testExportWhenSqlSchemaIsNotSet() throws Exception {
        WhenSqlSchemaNotSetTest.assertEquals((String)"default", (String)"default".toLowerCase());
        this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("\"default\".Person (_key, age, firstName, lastName)").intoTemp().toString());
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("\"" + "default".toUpperCase() + "\"." + TBL).intoTemp().toString()), SQLException.class, (String)"Schema \"DEFAULT\" not found");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("\"DEFault\".Person (_key, age, firstName, lastName)").intoTemp().toString()), SQLException.class, (String)"Schema \"DEFault\" not found");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("default.Person (_key, age, firstName, lastName)").intoTemp().toString()), SQLException.class, (String)"Schema \"DEFAULT\" not found");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("default".toUpperCase() + "." + TBL).intoTemp().toString()), SQLException.class, (String)"Schema \"DEFAULT\" not found");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("default".toLowerCase() + "." + TBL).intoTemp().toString()), SQLException.class, (String)"Schema \"DEFAULT\" not found");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("DEFault.Person (_key, age, firstName, lastName)").intoTemp().toString()), SQLException.class, (String)"Schema \"DEFAULT\" not found");
    }
}

