/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.ResultSet;
import java.util.HashMap;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.junit.Test;

public class WhenDdlTableTest
extends BulkLoadAbstractTest {
    @Override
    protected String getFormatDefault() {
        return "csv delimiter ','";
    }

    @Test
    public void testDdlTableExportCaseSensitive() throws Exception {
        this.stmt.executeUpdate("CREATE TABLE IF NOT EXISTS \"tbl_ddl\" (id LONG PRIMARY KEY, name VARCHAR)");
        this.stmt.executeUpdate("INSERT INTO \"tbl_ddl\" (id, name) VALUES (1, 'first')");
        this.stmt.executeUpdate("CREATE TABLE IF NOT EXISTS \"TBL_DDL\" (id LONG PRIMARY KEY, name VARCHAR)");
        this.stmt.executeUpdate("INSERT INTO \"TBL_DDL\" (id, name) VALUES (2, 'second')");
        this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("\"tbl_ddl\" (id, name)").intoTemp().toString());
        this.checkCacheContents("\"tbl_ddl\"", this.temp);
    }

    @Test
    public void testDdlTableImportCaseSensitive() throws Exception {
        this.stmt.executeUpdate("CREATE TABLE IF NOT EXISTS \"tbl_ddl\" (id LONG PRIMARY KEY, name VARCHAR)");
        this.stmt.executeUpdate("CREATE TABLE IF NOT EXISTS \"TBL_DDL\" (id LONG PRIMARY KEY, name VARCHAR)");
        Files.write(this.temp.toPath(), "3,third".getBytes(), new OpenOption[0]);
        this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from(WhenDdlTableTest.quoted(this.temp.getAbsolutePath())).into("\"tbl_ddl\" (id, name)").toString());
        this.checkCacheContents("\"tbl_ddl\"", this.temp);
        ResultSet resultSet = this.stmt.executeQuery("select id, name from \"TBL_DDL\"");
        WhenDdlTableTest.assertFalse((String)"No rows expected", (boolean)resultSet.next());
    }

    private void checkCacheContents(String tblName, File expectedFile) throws Exception {
        this.checkCacheContents(tblName, new FileInputStream(expectedFile), ",");
    }

    private void checkCacheContents(String tblName, FileInputStream expectedFileStream, String delimiterRegex) throws Exception {
        ResultSet rs = this.stmt.executeQuery("select id, name from " + tblName);
        HashMap<String, String[]> expectedData = new HashMap<String, String[]>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(expectedFileStream));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                String[] splitted = strLine.split(delimiterRegex);
                expectedData.put(splitted[0], splitted);
            }
        }
        int cnt = 0;
        while (rs.next()) {
            String[] currentRowExpectedData = (String[])expectedData.get(rs.getString("id"));
            WhenDdlTableTest.assertEquals((String)currentRowExpectedData[0], (String)rs.getString("id"));
            WhenDdlTableTest.assertEquals((String)currentRowExpectedData[1], (String)rs.getString("name"));
            ++cnt;
        }
        WhenDdlTableTest.assertEquals((int)expectedData.size(), (int)cnt);
    }
}

