/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.BulkLoadIcebergTest;
import org.gridgain.bulkload.model.PersonExtended;
import org.gridgain.bulkload.util.S3Utils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import software.amazon.awssdk.services.s3.S3Client;

public class BulkLoadS3IcebergTest
extends BulkLoadIcebergTest {
    private Map<String, String> properties;
    private S3Client s3;
    private String bucketName;
    private String prefix;

    @Before
    public void setUp() {
        this.bucketName = System.getenv("s3.bucket-name");
        this.prefix = UUID.randomUUID().toString();
        String warehouse = String.format("s3a://%s/%s", this.bucketName, this.prefix);
        this.properties = new HashMap<String, String>();
        this.properties.put("table-identifier", "PersonExtended");
        this.properties.put("catalog-impl", "org.apache.iceberg.hadoop.HadoopCatalog");
        this.properties.put("io-impl", "org.apache.iceberg.aws.s3.S3FileIO");
        this.properties.put("warehouse", warehouse);
        this.properties.put("s3.client-region", System.getenv("s3.client-region"));
        this.properties.put("s3.endpoint", System.getenv("s3.endpoint"));
        this.properties.put("s3.access-key-id", System.getenv("s3.access-key-id"));
        this.properties.put("s3.secret-access-key", System.getenv("s3.secret-access-key"));
        this.properties = Collections.unmodifiableMap(this.properties);
        this.s3 = S3Utils.s3client(this.properties);
    }

    @After
    public void tearDown() {
        S3Utils.cleanS3Bucket(this.s3, this.bucketName, this.prefix);
    }

    @Test
    public void testS3iceberg() throws Exception {
        HashMap<Long, PersonExtended> expected = new HashMap<Long, PersonExtended>();
        expected.put(1L, BulkLoadS3IcebergTest.newPerson(1L, "s3-test"));
        expected.put(2L, BulkLoadS3IcebergTest.newPersonEmpty(2L));
        IgniteCache cache = this.ignite(0).getOrCreateCache(this.cacheConfig());
        cache.putAll(expected);
        String sqlExport = new BulkLoadAbstractTest.Copy().from(TBL_EXTENDED).into(BulkLoadS3IcebergTest.quoted(this.properties.get("warehouse"))).format("ICEBERG").properties(this.properties).toString();
        this.stmt.executeUpdate(sqlExport);
        cache.clear();
        BulkLoadS3IcebergTest.assertNull((Object)cache.get((Object)1L));
        BulkLoadS3IcebergTest.assertNull((Object)cache.get((Object)2L));
        String sqlImport = new BulkLoadAbstractTest.Copy().from(BulkLoadS3IcebergTest.quoted(this.properties.get("warehouse"))).into(TBL_EXTENDED).format("ICEBERG").properties(this.properties).toString();
        this.stmt.executeUpdate(sqlImport);
        BulkLoadS3IcebergTest.assertColumnsEquals(TBL_COLS_EXTENDED, expected, (IgniteCache<Long, PersonExtended>)cache);
    }

    @Test
    public void testNoCredentials() {
        HashMap<String, String> propsOverride = new HashMap<String, String>(this.properties);
        propsOverride.put("warehouse", "s3a://wh");
        propsOverride.remove("s3.access-key-id");
        propsOverride.remove("s3.secret-access-key");
        propsOverride.remove("s3.client-region");
        String sqlExport = new BulkLoadAbstractTest.Copy().from(TBL_EXTENDED).into(BulkLoadS3IcebergTest.quoted((String)propsOverride.get("warehouse"))).format("ICEBERG").properties(propsOverride).toString();
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(sqlExport), SQLException.class, (String)"Failed to refresh the table");
    }

    @Test
    public void testNoRegion() {
        HashMap<String, String> propsOverride = new HashMap<String, String>(this.properties);
        propsOverride.remove("warehouse");
        propsOverride.remove("s3.client-region");
        propsOverride.remove("s3.endpoint");
        propsOverride.put("s3.access-key-id", "not-a-key");
        propsOverride.put("s3.secret-access-key", "not-a-key");
        String sqlExport = new BulkLoadAbstractTest.Copy().from(TBL_EXTENDED).into(BulkLoadS3IcebergTest.quoted((String)propsOverride.get("warehouse"))).format("ICEBERG").properties(propsOverride).toString();
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(sqlExport), SQLException.class, (String)"Unable to contact EC2 metadata service.");
    }

    @Test
    public void testS3schema() {
        HashMap<String, String> propsOverride = new HashMap<String, String>(this.properties);
        propsOverride.put("warehouse", "s3://wh");
        propsOverride.put("catalog-impl", "org.apache.iceberg.hadoop.HadoopCatalog");
        String sqlExport = new BulkLoadAbstractTest.Copy().from(TBL_EXTENDED).into(BulkLoadS3IcebergTest.quoted((String)propsOverride.get("warehouse"))).format("ICEBERG").properties(propsOverride).toString();
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(sqlExport), SQLException.class, (String)"Failed to get file system for path: s3://");
    }
}

