/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.bulkload.AbstractCsvTest;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.util.S3Utils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import software.amazon.awssdk.services.s3.S3Client;

public class BulkLoadS3CsvTest
extends AbstractCsvTest {
    private static final String TBL_NAME = "Person";
    private static final String BULKLOAD_CSV = "csv/bulkload.csv";
    public static final String TBL_COLS = " (_key, age, firstName, lastName)";
    private static final String TBL = "Person (_key, age, firstName, lastName)";
    private static Map<String, String> properties;
    private S3Client s3;
    private String bucketName;

    @Before
    public void setup() throws Exception {
        this.bucketName = System.getenv("s3.bucket-name");
        properties = new HashMap<String, String>();
        properties.put("s3.client-region", System.getenv("s3.client-region"));
        properties.put("s3.access-key-id", System.getenv("s3.access-key-id"));
        properties.put("s3.secret-access-key", System.getenv("s3.secret-access-key"));
        properties = Collections.unmodifiableMap(properties);
        this.s3 = S3Utils.s3client(properties);
    }

    @Test
    public void testBasic() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_CSV).into(TBL).toString());
        String uri = String.format("s3://%s/%s", this.bucketName, BULKLOAD_CSV);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).into(String.format("'%s'", uri)).properties(properties).toString());
        BulkLoadS3CsvTest.assertEquals((int)9, (int)updatesCnt);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(String.format("'%s'", uri)).into(TBL).properties(properties).toString());
        BulkLoadS3CsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_CSV);
    }

    @Test
    public void testFileExists() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_CSV).into(TBL).toString());
        String uri = String.format("s3://%s/%s", this.bucketName, BULKLOAD_CSV);
        S3Utils.uploadFileToS3Bucket(this.s3, this.bucketName, BULKLOAD_CSV, Paths.get(BulkLoadS3CsvTest.resolveAbsolutePath(BULKLOAD_CSV), new String[0]));
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).into(String.format("'%s'", uri)).properties(properties).toString()), SQLException.class, (String)"Key already exist");
    }

    @After
    public void tearDown() {
        S3Utils.cleanS3Bucket(this.s3, this.bucketName, BULKLOAD_CSV);
    }
}

