/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.BulkLoadParquetAbstractTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BulkLoadParquetDecimalTest
extends BulkLoadParquetAbstractTest {
    public static final String BULKLOAD_DECIMAL = "parquet/data_decimal.parquet";
    public static final String BULKLOAD_DECIMAL_EXPECTED = "parquet/data_decimal_expected.csv";
    public static final String BULKLOAD_DECIMAL_FIXED = "parquet/data_decimal_fixed.parquet";
    public static final String BULKLOAD_DECIMAL_FIXED_EXPECTED = "parquet/data_decimal_fixed_expected.csv";
    public static final String BULKLOAD_DECIMAL_FIXED_SCALE0_FIXED = "parquet/data_decimal_fixed_scale0.parquet";
    public static final String BULKLOAD_DECIMAL_FIXED_SCALE0_FIXED_EXPECTED = "parquet/data_decimal_fixed_scale0_expected.csv";
    public static final String BULKLOAD_DECIMAL_AS_LONG = "parquet/data_decimal_as_long.parquet";
    public static final String BULKLOAD_DECIMAL_AS_LONG_EXPECTED = "parquet/data_decimal_as_long_expected.csv";
    @Parameterized.Parameter
    public DecimalTestData testData;

    @Parameterized.Parameters
    public static Collection<DecimalTestData> parameters() {
        return Arrays.asList(new DecimalTestData("DECIMAL", BULKLOAD_DECIMAL, BULKLOAD_DECIMAL_EXPECTED), new DecimalTestData("DECIMAL(12,0)", BULKLOAD_DECIMAL_FIXED_SCALE0_FIXED, BULKLOAD_DECIMAL_FIXED_SCALE0_FIXED_EXPECTED), new DecimalTestData("DECIMAL(17,5)", BULKLOAD_DECIMAL_FIXED, BULKLOAD_DECIMAL_FIXED_EXPECTED), new DecimalTestData("DECIMAL(10,2)", BULKLOAD_DECIMAL_AS_LONG, BULKLOAD_DECIMAL_AS_LONG_EXPECTED));
    }

    @Before
    public void setup() throws SQLException {
        this.stmt.executeUpdate(String.format("CREATE TABLE decimalTest (id int, decimalField %s, PRIMARY KEY (id) );", this.testData.ddlDefinition));
    }

    @Test
    public void decimalTest() throws Exception {
        List<String> cols = Arrays.asList("id", "decimalField");
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().into("decimalTest(id, decimalField)").fromResource(this.testData.dataFile).toString());
        BulkLoadParquetDecimalTest.assertEquals((int)1, (int)updatesCnt);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from("decimalTest(id, decimalField)").intoTemp().toString());
        BulkLoadParquetDecimalTest.assertEquals((int)1, (int)updatesCnt);
        this.checkCacheContents("decimalTest", this.testData.expectedFile, cols);
        this.checkCacheContents("decimalTest", cols, this.readValuesFromParquetFile(BulkLoadParquetDecimalTest.resolveAbsolutePath(this.testData.dataFile), cols));
    }

    @After
    public void tearDown() throws SQLException {
        this.stmt.executeUpdate("DROP TABLE decimalTest;");
    }

    public static class DecimalTestData {
        public String ddlDefinition;
        public String dataFile;
        public String expectedFile;

        public DecimalTestData(String ddlDefinition, String dataFile, String expectedFile) {
            this.ddlDefinition = ddlDefinition;
            this.dataFile = dataFile;
            this.expectedFile = expectedFile;
        }
    }
}

