/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.util.Arrays;
import java.util.Collection;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.BulkLoadParquetAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BulkLoadParquetColumnsReorderTest
extends BulkLoadParquetAbstractTest {
    private static final String BULKLOAD_ALL_FIELDS = "parquet/all_fields_data.parquet";
    private static final String BULKLOAD_ALL_FIELDS_EXPECTED = "parquet/all_fields_data_expected.csv";
    @Parameterized.Parameter
    public String commaSeparatedColumns;

    @Parameterized.Parameters
    public static Collection<String> parameters() {
        return Arrays.asList("id,firstName,lastName,birthdate,registered,married,children,averageSalary", "firstName,id,lastName,birthdate,registered,married,children,averageSalary", "lastName,firstName,id,birthdate,registered,married,children,averageSalary", "birthdate,firstName,lastName,id,registered,married,children,averageSalary", "registered,firstName,lastName,birthdate,id,married,children,averageSalary", "married,firstName,lastName,birthdate,registered,id,children,averageSalary", "children,firstName,lastName,birthdate,registered,married,id,averageSalary", "averageSalary,firstName,lastName,birthdate,registered,married,children,id");
    }

    @Test
    public void importParquetReorderColumnsTest() throws Exception {
        String tblDesc = "PersonExtended(" + this.commaSeparatedColumns + ")";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_ALL_FIELDS).into(tblDesc).toString());
        BulkLoadParquetColumnsReorderTest.assertEquals((int)10, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", BULKLOAD_ALL_FIELDS_EXPECTED);
    }
}

