/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3OutputFile;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.parquet.Parquet;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.gridgain.bulkload.iceberg.IcebergUtils;
import org.gridgain.bulkload.io.Writer;
import org.gridgain.bulkload.s3.S3ClientFactory;
import org.gridgain.bulkload.s3.S3Utils;
import software.amazon.awssdk.services.s3.S3Client;

public class IcebergParquetWriter
implements Writer {
    private final Schema schema;
    private final DataWriter<Record> dataWriter;
    private final GenericRecord rec;

    public IcebergParquetWriter(BulkLoadLocationFile into, List<GridQueryFieldMetadata> fieldsMeta, Map<String, String> properties, IgniteLogger log) throws IOException {
        if (CollectionUtils.isEmpty(fieldsMeta)) {
            throw new IllegalArgumentException("Cannot read table table without schema descriptor");
        }
        this.schema = IcebergUtils.asIcebergSchema(fieldsMeta);
        OutputFile outputFile = this.getOutputFile(into.path(), IcebergUtils.combineProperties(into, properties));
        this.dataWriter = Parquet.writeData((OutputFile)outputFile).schema(this.schema).createWriterFunc(GenericParquetWriter::buildWriter).overwrite().withSpec(PartitionSpec.unpartitioned()).build();
        this.rec = GenericRecord.create((Schema)this.schema);
    }

    @Override
    public void writeAll(List<List<?>> batch) {
        for (List<?> row : batch) {
            this.dataWriter.write((Object)IcebergUtils.asRecord(row, this.rec, this.schema));
        }
    }

    @Override
    public void close() throws Exception {
        this.dataWriter.close();
    }

    private OutputFile getOutputFile(String path, Map<String, String> properties) {
        if (S3Utils.isS3Scheme(path)) {
            return S3OutputFile.fromLocation((String)path, (S3Client)S3ClientFactory.createS3Client(properties), (S3FileIOProperties)new S3FileIOProperties(), (MetricsContext)MetricsContext.nullMetrics());
        }
        return Files.localOutput((File)Paths.get(path, new String[0]).toFile());
    }
}

