/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.gridgain.bulkload.io.Reader;
import org.gridgain.bulkload.parquet.ObjectGroup;
import org.gridgain.bulkload.parquet.ParquetGroupUtils;
import org.gridgain.bulkload.parquet.RowGroupReader;

public class ParquetFileReader
implements Reader {
    private final IgniteLogger log;
    private final MessageType schema;
    private final org.apache.parquet.hadoop.ParquetFileReader parquetFileReader;
    private int totalRecordRead = 0;
    private RowGroupReader currentRowReader;
    private final List<String> columns;

    public ParquetFileReader(IgniteLogger log, InputFile inputFile, List<String> columns) throws IOException {
        this.log = log;
        this.columns = columns.stream().map(String::toLowerCase).collect(Collectors.toList());
        try {
            ParquetMetadata readFooter = org.apache.parquet.hadoop.ParquetFileReader.readFooter((InputFile)inputFile, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            this.schema = readFooter.getFileMetaData().getSchema();
            this.parquetFileReader = new org.apache.parquet.hadoop.ParquetFileReader(inputFile, ParquetReadOptions.builder().build());
        }
        catch (IOException e) {
            throw new IOException("Failed to read Parquet file: " + inputFile, e);
        }
    }

    @Override
    public boolean hasNext() {
        return (long)this.totalRecordRead < this.parquetFileReader.getRecordCount();
    }

    @Override
    public List<List<?>> nextBatch(int batchSize) throws IOException {
        ArrayList result = new ArrayList();
        if (!this.hasNext()) {
            return result;
        }
        if (this.currentRowReader == null) {
            this.currentRowReader = this.getNextRowGroup();
        }
        int currentBatchRead = 0;
        while (this.currentRowReader != null) {
            while (this.currentRowReader.hasNext() && currentBatchRead < batchSize) {
                try {
                    ObjectGroup group = this.currentRowReader.readNext();
                    result.add(this.getRowFromGroup(group));
                    ++currentBatchRead;
                }
                catch (Exception e) {
                    throw new IOException("Failed to read row from Parquet file", e);
                }
            }
            if (currentBatchRead >= batchSize) break;
            this.currentRowReader = this.getNextRowGroup();
        }
        this.totalRecordRead += currentBatchRead;
        return result;
    }

    private List<Object> getRowFromGroup(ObjectGroup group) {
        HashMap<String, Object> parquetValues = new HashMap<String, Object>();
        for (Type field : this.schema.getFields()) {
            parquetValues.put(field.getName().toLowerCase(), this.getValue(field, group, this.schema.getFieldIndex(field.getName())));
        }
        ArrayList<Object> row = new ArrayList<Object>();
        for (String column : this.columns) {
            row.add(parquetValues.get(column));
        }
        return row;
    }

    private Object getValue(Type columnType, ObjectGroup group, int index) {
        try {
            return ParquetGroupUtils.getValueFromGroup(columnType, group, index);
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
            return null;
        }
    }

    private RowGroupReader getNextRowGroup() throws IOException {
        PageReadStore pages = this.parquetFileReader.readNextRowGroup();
        if (pages != null) {
            return new RowGroupReader(this.schema, pages);
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        this.parquetFileReader.close();
    }

    public long totalRecordCount() {
        return this.parquetFileReader.getRecordCount();
    }

    public String getFileName() {
        return this.parquetFileReader.getFile();
    }

    public MessageType getSchema() {
        return this.schema;
    }

    @Override
    public List<GridQueryFieldMetadata> fieldsMeta() {
        return Collections.emptyList();
    }
}

