/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.util;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3Utils {
    public static final String BUCKET_NAME = "s3.bucket-name";

    public static S3Client s3client(final Map<String, String> properties) {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)properties.get("s3.client-region")))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)new AwsCredentials(){

            public String accessKeyId() {
                return (String)properties.get("s3.access-key-id");
            }

            public String secretAccessKey() {
                return (String)properties.get("s3.secret-access-key");
            }
        }))).build();
    }

    public static void cleanS3Bucket(S3Client s3, String bucketName, String prefix) {
        boolean hasContent = true;
        while (hasContent) {
            ListObjectsV2Response response = s3.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).prefix(prefix).build());
            hasContent = response.hasContents();
            if (!hasContent) continue;
            s3.deleteObjects((DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects((Collection)response.contents().stream().map(obj -> (ObjectIdentifier)ObjectIdentifier.builder().key(obj.key()).build()).collect(Collectors.toList())).build()).build());
        }
    }

    public static void uploadFileToS3Bucket(S3Client s3, String bucketName, String keyname, Path filename) {
        s3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(keyname).build(), filename);
    }
}

