/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.gridgain.bulkload.BulkLoadCsvTest;
import org.gridgain.bulkload.model.Person;
import org.gridgain.bulkload.model.PersonExtended;
import org.locationtech.jts.io.WKTReader;

public abstract class BulkLoadAbstractTest
extends AbstractIndexingCommonTest {
    protected Statement stmt;
    protected Connection conn;
    protected File temp;
    protected File tempDir;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.ignite(0).getOrCreateCache(this.cacheConfig());
        this.conn = this.createConnection();
        this.conn.setSchema("\"default\"");
        this.stmt = this.conn.createStatement();
        this.tempDir = Files.createTempDirectory("bulkload-test-", new FileAttribute[0]).toFile();
        this.temp = File.createTempFile("bulkload-test-", "", this.tempDir);
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.ignite(0).getOrCreateCache(this.cacheConfig()).clear();
        if (this.tempDir != null) {
            FileUtils.deleteDirectory((File)this.tempDir);
        }
    }

    protected abstract String getFormatDefault();

    protected Connection createConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/");
    }

    protected CacheConfiguration cacheConfig() {
        return this.nonBinCacheConfig(null);
    }

    protected CacheConfiguration nonBinCacheConfig(String keyFieldName) {
        CacheConfiguration cache = BulkLoadAbstractTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity person = this.applyKeyFieldName(new QueryEntity(Integer.class, Person.class), keyFieldName);
        QueryEntity personExtended = this.applyKeyFieldName(new QueryEntity(Long.class, PersonExtended.class), keyFieldName);
        cache.setQueryEntities(Arrays.asList(person, personExtended));
        return cache;
    }

    private QueryEntity applyKeyFieldName(QueryEntity entity, String keyFieldName) {
        if (keyFieldName != null) {
            entity.setKeyFieldName(keyFieldName);
        }
        return entity;
    }

    protected static String resolveAbsolutePath(String resource) {
        try {
            URL res = BulkLoadCsvTest.class.getClassLoader().getResource(resource);
            return Paths.get(res.toURI()).toFile().getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not resolve resource: " + resource, e);
        }
    }

    protected static String quoted(String string) {
        return "'" + string + "'";
    }

    protected static PersonExtended newPerson(long id, String prefix) throws Exception {
        return new PersonExtended(id, prefix + "_firstName", prefix + "_lastName", Date.valueOf(LocalDate.now()), Timestamp.from(Instant.now()), ThreadLocalRandom.current().nextBoolean(), ThreadLocalRandom.current().nextInt(0, 10), ThreadLocalRandom.current().nextDouble(100.0, 1000.0), ThreadLocalRandom.current().nextBoolean(), ThreadLocalRandom.current().nextLong(100L, 1000L), BulkLoadAbstractTest.nextBigDecimal(0.0, 100.001), ThreadLocalRandom.current().nextDouble(100.0, 1000.0), ThreadLocalRandom.current().nextInt(0, 10), Float.valueOf(ThreadLocalRandom.current().nextFloat()), (short)ThreadLocalRandom.current().nextInt(0, 100), (byte)ThreadLocalRandom.current().nextInt(0, 100), prefix + UUID.randomUUID(), Date.valueOf(LocalDate.now()), Time.valueOf(LocalTime.now()), Timestamp.from(Instant.now()), prefix.getBytes(), new WKTReader().read("POINT(1 2)"), UUID.randomUUID());
    }

    protected static PersonExtended newPersonEmpty(long id) {
        return new PersonExtended(id, null, null, null, null, null, null, null);
    }

    protected static BigDecimal nextBigDecimal(double min, double max) {
        BigDecimal minBig = new BigDecimal(min);
        BigDecimal maxBig = new BigDecimal(max);
        BigDecimal randomBigDecimal = minBig.add(new BigDecimal(Math.random()).multiply(maxBig.subtract(minBig)));
        return randomBigDecimal.setScale(2, RoundingMode.HALF_UP);
    }

    protected class Copy {
        private String from;
        private String into;
        private String format;
        private String pattern;
        private Map<String, String> properties;

        protected Copy() {
        }

        Copy from(String from) {
            this.from = from;
            return this;
        }

        Copy fromResource(String res) {
            this.from = BulkLoadAbstractTest.quoted(BulkLoadAbstractTest.resolveAbsolutePath(res));
            return this;
        }

        Copy into(String into) {
            this.into = into;
            return this;
        }

        Copy intoTemp() {
            this.into = BulkLoadAbstractTest.quoted(BulkLoadAbstractTest.this.temp.getAbsolutePath());
            return this;
        }

        Copy fromTemp() {
            this.from = BulkLoadAbstractTest.quoted(BulkLoadAbstractTest.this.temp.getAbsolutePath());
            return this;
        }

        Copy intoTempDir() {
            this.into = BulkLoadAbstractTest.quoted(BulkLoadAbstractTest.this.tempDir.getAbsolutePath());
            return this;
        }

        Copy fromTempDir() {
            this.from = BulkLoadAbstractTest.quoted(BulkLoadAbstractTest.this.tempDir.getAbsolutePath());
            return this;
        }

        Copy format(String format) {
            this.format = format;
            return this;
        }

        Copy pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        Copy properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public String toString() {
            String fmt = this.format == null ? BulkLoadAbstractTest.this.getFormatDefault() : this.format;
            String fmtPattern = this.pattern == null ? "" : String.format("PATTERN '%s'", this.pattern);
            String properties = this.getPropertiesString();
            return String.format("COPY FROM %s INTO %s FORMAT %s %s %s", this.from, this.into, fmt, fmtPattern, properties);
        }

        private String getPropertiesString() {
            return this.properties == null ? "" : this.properties.entrySet().stream().map(e -> "'" + (String)e.getKey() + "'='" + (String)e.getValue() + "'").collect(Collectors.joining(",", "PROPERTIES(", ")"));
        }
    }
}

