/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.util.HashMap;
import org.gridgain.bulkload.BulkLoadAbstractTest;

public class AbstractCsvTest
extends BulkLoadAbstractTest {
    protected void checkCacheContents(String tblName, File expectedFile, String delimiterRegex) throws Exception {
        this.checkCacheContents(tblName, new FileInputStream(expectedFile), delimiterRegex, false);
    }

    protected void checkCacheContents(String tblName, File expectedFile) throws Exception {
        this.checkCacheContents(tblName, new FileInputStream(expectedFile), ",", false);
    }

    protected void checkCacheContents(String tblName, File expectedFile, boolean header) throws Exception {
        this.checkCacheContents(tblName, new FileInputStream(expectedFile), ",", header);
    }

    protected void checkCacheContents(String tblName, String expectedFile) throws Exception {
        this.checkCacheContents(tblName, new FileInputStream(AbstractCsvTest.resolveAbsolutePath(expectedFile)), ",", false);
    }

    protected void checkCacheContents(String tblName, String expectedFile, boolean header) throws Exception {
        this.checkCacheContents(tblName, new FileInputStream(AbstractCsvTest.resolveAbsolutePath(expectedFile)), ",", header);
    }

    protected void checkCacheContents(String tblName, FileInputStream expectedFileStream, String delimiterRegex, boolean header) throws Exception {
        ResultSet rs = this.stmt.executeQuery("select _key, age, firstName, lastName from " + tblName);
        HashMap<String, String[]> expectedData = new HashMap<String, String[]>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(expectedFileStream));){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                String[] splitted = strLine.split(delimiterRegex);
                expectedData.put(splitted[0], splitted);
            }
        }
        int cnt = 0;
        while (rs.next()) {
            String[] currentRowExpectedData = (String[])expectedData.get(rs.getString("_key"));
            for (int i = 0; i < currentRowExpectedData.length; ++i) {
                AbstractCsvTest.assertEquals((String)currentRowExpectedData[i], (String)rs.getString(i + 1));
            }
            ++cnt;
        }
        int expectedSize = header ? expectedData.size() - 1 : expectedData.size();
        AbstractCsvTest.assertEquals((int)expectedSize, (int)cnt);
    }

    @Override
    protected String getFormatDefault() {
        return "csv";
    }
}

