/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.gridgain.bulkload.parquet.ObjectGroup;
import org.gridgain.bulkload.parquet.convert.GroupRecordConverter;

public class RowGroupReader {
    private final PageReadStore pageReadStore;
    private final RecordReader<Group> currentRecordReader;
    private long currentPageRead = 0L;

    public RowGroupReader(MessageType schema, PageReadStore pageReadStore) {
        this.pageReadStore = pageReadStore;
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(schema);
        this.currentRecordReader = columnIO.getRecordReader(pageReadStore, (RecordMaterializer)new GroupRecordConverter(schema));
    }

    public boolean hasNext() {
        return this.currentPageRead < this.pageReadStore.getRowCount();
    }

    public ObjectGroup readNext() {
        if (this.hasNext()) {
            ++this.currentPageRead;
            return (ObjectGroup)((Object)this.currentRecordReader.read());
        }
        return null;
    }
}

