/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.UUID;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.Int96Value;
import org.apache.parquet.example.data.simple.NanoTime;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.gridgain.bulkload.parquet.ObjectGroup;
import org.gridgain.bulkload.parquet.ParquetTimestampUtils;
import org.gridgain.bulkload.parquet.ParquetUuidUtils;

public class ParquetGroupUtils {
    public static final int DECIMAL_PRECISION = 38;
    public static final int DECIMAL_PRECISION_IGNITE_DEFAULT = 65535;
    public static final int DECIMAL_SCALE = 20;
    public static final int DECIMAL_SCALE_IGNITE_DEFAULT = Short.MAX_VALUE;

    public static Object getValueFromGroup(Type columnType, ObjectGroup group, int index) {
        if (group.getValue(index, 0) == null) {
            return null;
        }
        LogicalTypeAnnotation typeAnnotation = columnType.getLogicalTypeAnnotation();
        if (typeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            return LocalDate.ofEpochDay(group.getInteger(index, 0));
        }
        if (typeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            return ParquetTimestampUtils.getTimestamp(group.getLong(index, 0), columnType.getLogicalTypeAnnotation());
        }
        if (typeAnnotation instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
            return group.getString(index, 0);
        }
        if (typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)columnType.getLogicalTypeAnnotation();
            PrimitiveType.PrimitiveTypeName primitiveTypeName = columnType.asPrimitiveType().getPrimitiveTypeName();
            switch (primitiveTypeName) {
                case INT32: {
                    return BigDecimal.valueOf(group.getInteger(index, 0), decimalAnnotation.getScale());
                }
                case INT64: {
                    return BigDecimal.valueOf(group.getLong(index, 0), decimalAnnotation.getScale());
                }
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    return new BigDecimal(new BigInteger(group.getBinary(index, 0).getBytes()), decimalAnnotation.getScale());
                }
            }
        } else {
            if (LogicalTypeAnnotation.uuidType().equals(columnType.getLogicalTypeAnnotation())) {
                return ParquetUuidUtils.fromBinaryToUUID(group.getBinary(index, 0));
            }
            if (columnType.isPrimitive()) {
                PrimitiveType.PrimitiveTypeName primitiveTypeName = columnType.asPrimitiveType().getPrimitiveTypeName();
                switch (primitiveTypeName) {
                    case INT32: {
                        return group.getInteger(index, 0);
                    }
                    case INT64: {
                        if (ParquetTimestampUtils.isInt64Timestamp(columnType.getLogicalTypeAnnotation())) {
                            return ParquetTimestampUtils.getTimestamp(group.getLong(index, 0), columnType.getLogicalTypeAnnotation());
                        }
                        return group.getLong(index, 0);
                    }
                    case FLOAT: {
                        return Float.valueOf(group.getFloat(index, 0));
                    }
                    case DOUBLE: {
                        return group.getDouble(index, 0);
                    }
                    case BOOLEAN: {
                        return group.getBoolean(index, 0);
                    }
                    case BINARY: {
                        return group.getBinary(index, 0).getBytes();
                    }
                    case INT96: {
                        Int96Value int96 = new Int96Value(group.getInt96(index, 0));
                        return new Timestamp(ParquetTimestampUtils.getTimestampMillis(int96.getInt96()));
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        return group.getBinary(index, 0);
                    }
                }
            }
        }
        return group.getValueToString(index, 0);
    }

    public static void putValueToGroup(Group group, String columnName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            group.add(columnName, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            group.add(columnName, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            group.add(columnName, ((Long)value).longValue());
        } else if (value instanceof Double) {
            group.add(columnName, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            group.add(columnName, (String)value);
        } else if (value instanceof Date) {
            long epochDay = ((Date)value).toLocalDate().toEpochDay();
            group.add(columnName, Long.valueOf(epochDay).intValue());
        } else if (value instanceof Timestamp) {
            Timestamp val = (Timestamp)value;
            NanoTime nanoTime = new NanoTime(ParquetTimestampUtils.getJulianDay(val), ParquetTimestampUtils.getTimeOfDayNanos(val));
            group.add(columnName, nanoTime);
        } else if (value instanceof UUID) {
            group.add(columnName, ParquetUuidUtils.fromUUID((UUID)value));
        } else if (value instanceof byte[]) {
            group.add(columnName, Binary.fromConstantByteArray((byte[])((byte[])value)));
        } else if (value instanceof BigDecimal) {
            BigDecimal val = (BigDecimal)value;
            BigInteger unscaled = val.scaleByPowerOfTen(val.scale()).toBigInteger();
            group.add(columnName, Binary.fromByteArray((byte[])unscaled.toByteArray()));
        } else {
            group.add(columnName, value.toString());
        }
    }
}

