/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class LocalInputFile
implements InputFile {
    private final Path path;
    private long length = -1L;

    public LocalInputFile(Path file) {
        this.path = file;
    }

    public long getLength() throws IOException {
        if (this.length == -1L) {
            try (RandomAccessFile file = new RandomAccessFile(this.path.toFile(), "r");){
                this.length = file.length();
            }
        }
        return this.length;
    }

    public SeekableInputStream newStream() throws IOException {
        return new SeekableInputStream(){
            private final RandomAccessFile randomAccessFile;
            {
                this.randomAccessFile = new RandomAccessFile(LocalInputFile.this.path.toFile(), "r");
            }

            public int read() throws IOException {
                return this.randomAccessFile.read();
            }

            public long getPos() throws IOException {
                return this.randomAccessFile.getFilePointer();
            }

            public void seek(long newPos) throws IOException {
                this.randomAccessFile.seek(newPos);
            }

            public void readFully(byte[] bytes) throws IOException {
                this.randomAccessFile.readFully(bytes);
            }

            public void readFully(byte[] bytes, int start, int len) throws IOException {
                this.randomAccessFile.readFully(bytes, start, len);
            }

            public int read(ByteBuffer buf) throws IOException {
                byte[] buffer = new byte[buf.remaining()];
                int code = this.read(buffer);
                buf.put(buffer, buf.position() + buf.arrayOffset(), buf.remaining());
                return code;
            }

            public void readFully(ByteBuffer buf) throws IOException {
                byte[] buffer = new byte[buf.remaining()];
                this.readFully(buffer);
                buf.put(buffer, buf.position() + buf.arrayOffset(), buf.remaining());
            }

            public void close() throws IOException {
                this.randomAccessFile.close();
            }
        };
    }

    public String toString() {
        return "LocalInputFile{path=" + this.path + ", length=" + this.length + '}';
    }
}

