/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.s3;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.gridgain.bulkload.parquet.s3.S3InputFile;
import org.gridgain.bulkload.parquet.s3.S3OutputFile;
import org.gridgain.bulkload.s3.S3InputStream;
import org.gridgain.bulkload.s3.S3OutputStream;
import org.gridgain.bulkload.s3.S3URI;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class S3ClientFactory {
    public static Reader getInputStreamReader(String path, Map<String, String> properties, IgniteLogger log) {
        S3Client s3Client = S3ClientFactory.createS3Client(properties);
        S3InputStream s3InputStream = new S3InputStream(s3Client, new S3URI(path), log);
        return new InputStreamReader((InputStream)((Object)s3InputStream));
    }

    public static Writer getOutputStreamWriter(String path, Map<String, String> properties, IgniteLogger log) throws IOException {
        S3URI uri;
        S3Client s3Client = S3ClientFactory.createS3Client(properties);
        if (S3ClientFactory.keyExist(s3Client, uri = new S3URI(path))) {
            throw new IOException("Key already exists: " + path);
        }
        S3OutputStream s3OutputStream = new S3OutputStream(s3Client, uri, log);
        return new OutputStreamWriter((OutputStream)((Object)s3OutputStream));
    }

    public static InputFile getS3InputFile(String path, Map<String, String> properties, IgniteLogger log) {
        S3Client s3Client = S3ClientFactory.createS3Client(properties);
        return S3InputFile.fromLocation(path, s3Client, log);
    }

    public static OutputFile getS3OutputFile(String path, Map<String, String> properties, IgniteLogger log) throws IOException {
        S3Client s3Client = S3ClientFactory.createS3Client(properties);
        if (S3ClientFactory.keyExist(s3Client, new S3URI(path))) {
            throw new IOException("Key already exists: " + path);
        }
        return S3OutputFile.fromLocation(path, s3Client, log);
    }

    public static S3Client createS3Client(Map<String, String> properties) {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)properties.get("s3.client-region")))).credentialsProvider(S3ClientFactory.createCredentialProvider(properties))).build();
    }

    private static boolean keyExist(S3Client client, S3URI uri) {
        try {
            HeadObjectRequest.Builder requestBuilder = HeadObjectRequest.builder().bucket(uri.bucket()).key(uri.key());
            return client.headObject((HeadObjectRequest)requestBuilder.build()) != null;
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    private static AwsCredentialsProvider createCredentialProvider(final Map<String, String> properties) {
        return StaticCredentialsProvider.create((AwsCredentials)new AwsCredentials(){

            public String accessKeyId() {
                return (String)properties.get("s3.access-key-id");
            }

            public String secretAccessKey() {
                return (String)properties.get("s3.secret-access-key");
            }
        });
    }
}

