/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.gridgain.bulkload.exception.UnsupportedTimestampAnnotationException;

public class ParquetTimestampUtils {
    public static final LogicalTypeAnnotation.TimestampLogicalTypeAnnotation TIMESTAMP_MILLIS_UTC = LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
    public static final LogicalTypeAnnotation.TimestampLogicalTypeAnnotation TIMESTAMP_MILLIS = LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
    public static final LogicalTypeAnnotation.TimestampLogicalTypeAnnotation TIMESTAMP_MICROS_UTC = LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
    public static final LogicalTypeAnnotation.TimestampLogicalTypeAnnotation TIMESTAMP_MICROS = LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
    private static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);

    public static long getTimestampMillis(Binary timestampBinary) {
        if (timestampBinary.length() != 12) {
            throw new RuntimeException("Parquet timestamp must be 12 bytes, actual " + timestampBinary.length());
        }
        byte[] bytes = timestampBinary.getBytes();
        long timeOfDayNanos = Longs.fromBytes((byte)bytes[7], (byte)bytes[6], (byte)bytes[5], (byte)bytes[4], (byte)bytes[3], (byte)bytes[2], (byte)bytes[1], (byte)bytes[0]);
        int julianDay = Ints.fromBytes((byte)bytes[11], (byte)bytes[10], (byte)bytes[9], (byte)bytes[8]);
        return ParquetTimestampUtils.julianDayToMillis(julianDay) + timeOfDayNanos / NANOS_PER_MILLISECOND;
    }

    public static int getJulianDay(Timestamp timestamp) {
        long millisSinceEpoch = timestamp.getTime();
        return (int)(millisSinceEpoch / MILLIS_IN_DAY) + 2440588;
    }

    public static long getTimeOfDayNanos(Timestamp timestamp) {
        long millisSinceMidnight = timestamp.getTime() % MILLIS_IN_DAY;
        return millisSinceMidnight * 1000000L;
    }

    private static long julianDayToMillis(int julianDay) {
        return (long)(julianDay - 2440588) * MILLIS_IN_DAY;
    }

    public static boolean isInt64Timestamp(LogicalTypeAnnotation typeAnnotation) {
        return TIMESTAMP_MILLIS_UTC.equals((Object)typeAnnotation) || TIMESTAMP_MILLIS.equals((Object)typeAnnotation) || TIMESTAMP_MICROS_UTC.equals((Object)typeAnnotation) || TIMESTAMP_MICROS.equals((Object)typeAnnotation);
    }

    public static Timestamp getTimestamp(long value, LogicalTypeAnnotation typeAnnotation) {
        if (TIMESTAMP_MILLIS_UTC.equals((Object)typeAnnotation)) {
            return Timestamp.from(Instant.ofEpochMilli(value));
        }
        if (TIMESTAMP_MICROS_UTC.equals((Object)typeAnnotation)) {
            return Timestamp.from(ParquetTimestampUtils.getInstantFromMicrosEpoch(value));
        }
        if (TIMESTAMP_MILLIS.equals((Object)typeAnnotation)) {
            return Timestamp.valueOf(LocalDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneId.systemDefault()));
        }
        if (TIMESTAMP_MICROS.equals((Object)typeAnnotation)) {
            return Timestamp.valueOf(LocalDateTime.ofInstant(ParquetTimestampUtils.getInstantFromMicrosEpoch(value), ZoneId.systemDefault()));
        }
        throw new UnsupportedTimestampAnnotationException(typeAnnotation.toString());
    }

    private static Instant getInstantFromMicrosEpoch(long micros) {
        return Instant.ofEpochSecond(TimeUnit.MICROSECONDS.toSeconds(micros), TimeUnit.MICROSECONDS.toNanos(Math.floorMod(micros, TimeUnit.SECONDS.toMicros(1L))));
    }
}

