/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParquetFormat;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.parquet.Strings;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.gridgain.bulkload.ParquetFileReader;
import org.gridgain.bulkload.io.Reader;
import org.gridgain.bulkload.parquet.LocalInputFile;
import org.gridgain.bulkload.s3.S3ClientFactory;
import org.gridgain.bulkload.s3.S3Utils;
import org.gridgain.bulkload.util.PathUtils;

@Deprecated
public class ParquetReader
implements Reader {
    private ParquetFileReader currentParquetFileReader;
    private final List<ParquetFileReader> parquetFileReaderList = new ArrayList<ParquetFileReader>();
    private final Iterator<ParquetFileReader> parquetFileReaderIterator;
    private long totalRecordCount = 0L;
    private int totalRecordRead = 0;
    private final IgniteLogger log;

    public ParquetReader(BulkLoadLocationFile from, BulkLoadParquetFormat fmt, List<String> columns, Map<String, String> properties, IgniteLogger log) throws IOException {
        List<InputFile> inputFiles = this.getInputFilesFromPattern(from.path(), fmt.pattern(), properties);
        if (inputFiles.isEmpty()) {
            throw new IOException("No files to read from matching pattern: '" + fmt.pattern() + "'");
        }
        for (InputFile inputFile : inputFiles) {
            this.parquetFileReaderList.add(new ParquetFileReader(log, inputFile, columns));
        }
        if (!this.validateSchemas(this.parquetFileReaderList)) {
            throw new IOException("All parquet files must have the same schema");
        }
        this.totalRecordCount = this.parquetFileReaderList.stream().mapToLong(ParquetFileReader::totalRecordCount).sum();
        this.parquetFileReaderIterator = this.parquetFileReaderList.iterator();
        this.currentParquetFileReader = this.parquetFileReaderIterator.next();
        this.log = log;
    }

    @Override
    public boolean hasNext() {
        return (long)this.totalRecordRead < this.totalRecordCount;
    }

    private List<InputFile> getInputFilesFromPattern(String path, String pattern, Map<String, String> properties) throws IOException {
        if (Strings.isNullOrEmpty((String)pattern)) {
            if (S3Utils.isS3Scheme(path)) {
                return Collections.singletonList(S3ClientFactory.getS3InputFile(path, properties, this.log));
            }
            return Collections.singletonList(new LocalInputFile(Paths.get(path, new String[0])));
        }
        List<Path> matchedFiles = PathUtils.getFilesByPattern(path, pattern);
        return matchedFiles.stream().map(LocalInputFile::new).collect(Collectors.toList());
    }

    @Override
    public List<List<?>> nextBatch(int batchSize) throws IOException {
        try {
            List<List<?>> result = this.currentParquetFileReader.nextBatch(batchSize);
            if (result.size() < batchSize && this.parquetFileReaderIterator.hasNext()) {
                this.currentParquetFileReader = this.parquetFileReaderIterator.next();
                result.addAll(this.currentParquetFileReader.nextBatch(batchSize - result.size()));
            }
            this.totalRecordRead += result.size();
            return result;
        }
        catch (IOException e) {
            throw new IOException("Could not read data from file: " + this.currentParquetFileReader.getFileName(), e);
        }
    }

    @Override
    public void close() throws Exception {
        for (ParquetFileReader parquetFileReader : this.parquetFileReaderList) {
            parquetFileReader.close();
        }
    }

    private boolean validateSchemas(List<ParquetFileReader> list) {
        if (list.size() > 1) {
            MessageType firstScheme = list.get(0).getSchema();
            return list.stream().map(ParquetFileReader::getSchema).allMatch(x -> x.equals((Object)firstScheme));
        }
        return true;
    }

    @Override
    public List<GridQueryFieldMetadata> fieldsMeta() {
        return Collections.emptyList();
    }
}

