/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocation;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationQuery;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationTable;
import org.apache.ignite.internal.processors.cache.query.QueryCursorEx;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.gridgain.bulkload.io.Reader;
import org.gridgain.internal.h2.command.Parser;

public class CacheReader
implements Reader {
    private final FieldsQueryCursor<List<?>> cursor;
    private final Iterator<List<?>> iterator;

    public CacheReader(GridKernalContext ctx, BulkLoadLocation from) {
        String sql = this.toSql(from);
        this.cursor = ctx.query().querySqlFields(new SqlFieldsQuery(sql).setLazy(true), true);
        this.iterator = this.cursor.iterator();
    }

    private String toSql(BulkLoadLocation from) {
        if (from instanceof BulkLoadLocationTable) {
            BulkLoadLocationTable tbl = (BulkLoadLocationTable)from;
            StringJoiner columns = new StringJoiner(", ");
            for (String column : tbl.columns()) {
                columns.add(column);
            }
            return "SELECT " + columns + " FROM " + this.toIdentifier(tbl);
        }
        if (from instanceof BulkLoadLocationQuery) {
            return ((BulkLoadLocationQuery)from).sql();
        }
        throw new IgniteSQLException("Unexpected location COPY FROM", 2002);
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<List<?>> nextBatch(int batchSize) throws IOException {
        try {
            ArrayList res = new ArrayList();
            for (int i = 0; i < batchSize && this.iterator.hasNext(); ++i) {
                res.add(this.iterator.next());
            }
            return res;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private String toIdentifier(BulkLoadLocationTable tbl) {
        return Parser.quoteIdentifier((String)tbl.schemaName(), (boolean)tbl.isSchemaNameQuoted()) + "." + Parser.quoteIdentifier((String)tbl.tableName(), (boolean)tbl.isTableNameQuoted());
    }

    @Override
    public List<GridQueryFieldMetadata> fieldsMeta() {
        return ((QueryCursorEx)this.cursor).fieldsMeta();
    }
}

