/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParquetFormat;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.parquet.IcebergParquetReader;

public class BulkLoadParquetAbstractTest
extends BulkLoadAbstractTest {
    protected static final String TBL_NAME = "PersonExtended";
    protected static final List<String> TBL_COLUMNS = Arrays.asList("id", "firstName", "lastName", "birthdate", "registered", "married", "children", "averageSalary");
    protected static final String TBL = "PersonExtended(" + String.join((CharSequence)",", TBL_COLUMNS) + ")";
    protected static final DateTimeFormatter EXPECTED_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S");

    protected void checkCacheContents(String tblName, String expectedFilename, List<String> columns) throws Exception {
        String strLine;
        ResultSet rs = this.stmt.executeQuery("select " + String.join((CharSequence)",", columns) + " from " + tblName);
        HashMap<String, String[]> expectedData = new HashMap<String, String[]>();
        FileInputStream fstream = new FileInputStream(BulkLoadParquetAbstractTest.resolveAbsolutePath(expectedFilename));
        BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
        while ((strLine = br.readLine()) != null) {
            String[] splitted = strLine.split(",");
            expectedData.put(splitted[0], splitted);
        }
        int cnt = 0;
        while (rs.next()) {
            String[] currentRowExpectedData = (String[])expectedData.get(rs.getString(columns.get(0)));
            int csvColumnNum = 0;
            for (String column : columns) {
                String actual = this.normalizeStringValue(this.getValueFromResultSet(rs, column), column);
                String expected = this.normalizeStringValue(currentRowExpectedData[csvColumnNum], column);
                BulkLoadParquetAbstractTest.assertEquals((String)expected, (String)actual);
                ++csvColumnNum;
            }
            ++cnt;
        }
        BulkLoadParquetAbstractTest.assertEquals((int)expectedData.size(), (int)cnt);
    }

    private String getValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
        if (columnName.equals("bin")) {
            return new String(rs.getBytes(columnName));
        }
        return rs.getString(columnName);
    }

    protected String normalizeStringValue(Object value, String columnName) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        if ("registered".equals(columnName) || "timestamp_millis".equals(columnName) || "timestamp_micros".equals(columnName)) {
            return this.convertDateTimeToLocal(value.toString());
        }
        return value.toString();
    }

    private String convertDateTimeToLocal(String datetime) {
        LocalDateTime ldt = datetime.contains("T") ? LocalDateTime.parse(datetime) : LocalDateTime.parse(datetime.replaceAll("\\..*", ""), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return ldt.atZone(ZoneId.of("UTC")).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
    }

    protected void checkCacheContents(String tblName, List<String> columns, List<List<?>> expectedValues) throws Exception {
        ResultSet rs = this.stmt.executeQuery("select " + String.join((CharSequence)",", columns) + " from " + tblName + " order by _key");
        int cnt = 0;
        while (rs.next()) {
            List<?> currentRowExpectedData = expectedValues.get(cnt);
            int csvColumnNum = 0;
            for (String column : columns) {
                String expected = null;
                if (currentRowExpectedData.get(csvColumnNum) instanceof byte[]) {
                    expected = new String((byte[])currentRowExpectedData.get(csvColumnNum));
                } else if (currentRowExpectedData.get(csvColumnNum) != null) {
                    expected = currentRowExpectedData.get(csvColumnNum).toString();
                }
                expected = this.normalizeStringValue(expected, column);
                String actual = this.normalizeStringValue(this.getValueFromResultSet(rs, column), column);
                BulkLoadParquetAbstractTest.assertEquals((String)expected, (String)actual);
                ++csvColumnNum;
            }
            ++cnt;
        }
        BulkLoadParquetAbstractTest.assertEquals((int)expectedValues.size(), (int)cnt);
    }

    protected List<List<?>> readValuesFromParquetFile(File file, List<String> cols) throws Exception {
        List result;
        try (IcebergParquetReader reader = new IcebergParquetReader(new BulkLoadLocationFile().path(file.getPath()), new BulkLoadParquetFormat(), cols, new HashMap(), this.log());){
            result = reader.nextBatch(2048);
        }
        result.sort(Comparator.comparing(e -> Long.parseLong(e.get(0).toString())));
        return result;
    }

    protected List<List<?>> readValuesFromParquetFile(String path, List<String> cols) throws Exception {
        return this.readValuesFromParquetFile(Paths.get(path, new String[0]).toFile(), cols);
    }

    protected void checkCacheContents(String tblName, String expectedFilename) throws Exception {
        this.checkCacheContents(tblName, expectedFilename, TBL_COLUMNS);
    }

    @Override
    protected String getFormatDefault() {
        return "parquet";
    }

    @Override
    protected CacheConfiguration cacheConfig() {
        return this.nonBinCacheConfig("id");
    }
}

