/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet.s3;

import org.gridgain.bulkload.s3.S3URI;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;

abstract class BaseS3File {
    private final S3Client client;
    private final S3URI uri;

    BaseS3File(S3Client client, S3URI uri) {
        this.client = client;
        this.uri = uri;
    }

    public String location() {
        return this.uri.location();
    }

    public S3Client client() {
        return this.client;
    }

    public S3URI uri() {
        return this.uri;
    }

    protected HeadObjectResponse getObjectMetadata() throws S3Exception {
        HeadObjectRequest.Builder requestBuilder = HeadObjectRequest.builder().bucket(this.uri().bucket()).key(this.uri().key());
        return this.client().headObject((HeadObjectRequest)requestBuilder.build());
    }

    public String toString() {
        return this.uri.toString();
    }
}

