/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.iceberg;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import software.amazon.awssdk.core.SdkSystemSetting;

public final class IcebergUtils {
    public static final int DECIMAL_PRECISION = 38;
    public static final int DECIMAL_SCALE = 20;

    private IcebergUtils() {
    }

    public static Map<String, String> combineProperties(BulkLoadLocationFile location, Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties);
        result.computeIfAbsent("warehouse", k -> location.path());
        result.computeIfAbsent("client.region", k -> (String)properties.get("s3.client-region"));
        return result;
    }

    public static Configuration combineConfiguration(Map<String, String> properties) {
        Configuration conf = new Configuration();
        Optional.ofNullable(ObjectUtils.firstNonNull((Object[])new String[]{properties.get("s3.access-key-id"), properties.get("fs.s3a.access.key"), properties.get(SdkSystemSetting.AWS_ACCESS_KEY_ID.property())})).ifPresent(v -> {
            conf.set("fs.s3a.access.key", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.accessKeyId"), System.getenv("AWS_ACCESS_KEY_ID"), System.getenv("AWS_ACCESS_KEY")})) {
                System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), v);
            }
        });
        Optional.ofNullable(ObjectUtils.firstNonNull((Object[])new String[]{properties.get("s3.secret-access-key"), properties.get("fs.s3a.secret.key"), properties.get(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property())})).ifPresent(v -> {
            conf.set("fs.s3a.secret.key", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.secretKey"), System.getenv("AWS_SECRET_KEY"), System.getenv("AWS_SECRET_ACCESS_KEY")})) {
                System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), v);
            }
        });
        Optional.ofNullable(ObjectUtils.firstNonNull((Object[])new String[]{properties.get("s3.session-token"), properties.get("fs.s3a.session.token"), properties.get(SdkSystemSetting.AWS_SESSION_TOKEN.property())})).ifPresent(v -> {
            conf.set("fs.s3a.session.token", v);
            if (ObjectUtils.allNull((Object[])new Object[]{System.getProperty("aws.sessionToken"), System.getenv("AWS_SESSION_TOKEN")})) {
                System.setProperty(SdkSystemSetting.AWS_SESSION_TOKEN.property(), v);
            }
        });
        Optional.ofNullable(ObjectUtils.firstNonNull((Object[])new String[]{properties.get("client.region"), properties.get("fs.s3a.endpoint.region"), properties.get("s3.client-region")})).ifPresent(v -> conf.set("fs.s3a.endpoint.region", v));
        return conf;
    }

    static List<Object> asList(Record rec) {
        int size = rec.size();
        ArrayList<Object> res = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            res.add(IcebergUtils.asGridGainValue(rec.get(i)));
        }
        return res;
    }

    static GenericRecord asRecord(List<?> row, GenericRecord rec, Schema schema) {
        HashMap<String, Object> recordValues = new HashMap<String, Object>(row.size(), 1.0f);
        for (int i = 0; i < row.size(); ++i) {
            String columnName = schema.findColumnName(i + 1);
            Object value = IcebergUtils.asIcebergValue(row.get(i));
            recordValues.put(columnName, value);
        }
        return rec.copy(recordValues);
    }

    static Schema asIcebergSchema(List<GridQueryFieldMetadata> ggColumns) {
        List icebergColumns = IntStream.range(1, ggColumns.size() + 1).boxed().collect(Collectors.toMap(i -> i, index -> (GridQueryFieldMetadata)ggColumns.get(index - 1))).entrySet().stream().map(e -> {
            int id = (Integer)e.getKey();
            boolean isOptional = ((GridQueryFieldMetadata)e.getValue()).nullability() > 0;
            String name = ((GridQueryFieldMetadata)e.getValue()).fieldName();
            Type type = IcebergUtils.asIcebergType((GridQueryFieldMetadata)e.getValue());
            return Types.NestedField.of((int)id, (boolean)isOptional, (String)name, (Type)type);
        }).collect(Collectors.toList());
        return new Schema(icebergColumns);
    }

    private static Type asIcebergType(GridQueryFieldMetadata meta) {
        String typeString = meta.fieldTypeName();
        if ("[B".equals(typeString) && meta.precision() != 16) {
            return Types.BinaryType.get();
        }
        if ("[B".equals(typeString) && meta.precision() == 16) {
            return Types.UUIDType.get();
        }
        if (BigDecimal.class.getName().equals(typeString)) {
            return Types.DecimalType.of((int)38, (int)20);
        }
        if (Byte.class.getName().equals(typeString)) {
            return Types.IntegerType.get();
        }
        if (Integer.class.getName().equals(typeString)) {
            return Types.IntegerType.get();
        }
        if (OffsetDateTime.class.getName().equals(typeString)) {
            return Types.TimestampType.withZone();
        }
        if (Short.class.getName().equals(typeString)) {
            return Types.IntegerType.get();
        }
        String typeStringShort = StringUtils.substringAfterLast((String)typeString, (String)".");
        return Types.fromPrimitiveString((String)typeStringShort);
    }

    public static Object asIcebergValue(Object o) {
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).setScale(20, RoundingMode.HALF_UP);
        }
        if (o instanceof Byte) {
            return ((Byte)o).intValue();
        }
        if (o instanceof byte[]) {
            return ByteBuffer.wrap((byte[])o);
        }
        if (o instanceof Date) {
            return ((Date)o).toLocalDate();
        }
        if (o instanceof Short) {
            return ((Short)o).intValue();
        }
        if (o instanceof Time) {
            return ((Time)o).toLocalTime();
        }
        if (o instanceof Timestamp) {
            return ((Timestamp)o).toLocalDateTime();
        }
        if (o instanceof UUID) {
            return UUIDUtil.convert((UUID)((UUID)o));
        }
        return o;
    }

    public static Object asGridGainValue(Object o) {
        if (o instanceof byte[] && ((byte[])o).length == 16) {
            return UUIDUtil.convert((byte[])((byte[])o));
        }
        if (o instanceof ByteBuffer) {
            return ((ByteBuffer)o).array();
        }
        if (o instanceof LocalDate) {
            return Date.valueOf((LocalDate)o);
        }
        if (o instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)o);
        }
        if (o instanceof LocalTime) {
            return Time.valueOf((LocalTime)o);
        }
        return o;
    }
}

