/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.ignite.internal.processors.bulkload.BulkLoadLocationFile;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupFactory;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Types;
import org.gridgain.bulkload.io.Writer;
import org.gridgain.bulkload.parquet.GroupParquetWriter;
import org.gridgain.bulkload.parquet.GroupWriteSupport;
import org.gridgain.bulkload.parquet.LocalOutputFile;
import org.gridgain.bulkload.parquet.ParquetGroupSchemaUtils;
import org.gridgain.bulkload.parquet.ParquetGroupUtils;
import org.gridgain.bulkload.s3.S3ClientFactory;
import org.gridgain.bulkload.s3.S3Utils;

public class ParquetWriter
implements Writer {
    private static final Logger LOGGER = Logger.getLogger(ParquetWriter.class.getName());
    private final MessageType schema;
    GroupFactory groupFactory;
    org.apache.parquet.hadoop.ParquetWriter<Group> writer;

    public ParquetWriter(BulkLoadLocationFile into, List<GridQueryFieldMetadata> fieldsMeta, Map<String, String> properties) throws IOException {
        Types.MessageTypeBuilder messageTypeBuilder = Types.buildMessage();
        for (GridQueryFieldMetadata meta : fieldsMeta) {
            messageTypeBuilder.addField(ParquetGroupSchemaUtils.getParquetType(meta));
        }
        this.schema = messageTypeBuilder.named("schema");
        this.groupFactory = new SimpleGroupFactory(this.schema);
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema(this.schema, conf);
        OutputFile outputFile = this.getOutputFile(into.path(), properties);
        try {
            this.writer = ((GroupParquetWriter.Builder)((GroupParquetWriter.Builder)GroupParquetWriter.builder(outputFile).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withConf(conf)).build();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to write Parquet file: " + into.path(), e);
            throw new IOException("Failed to write Parquet file: " + into.path(), e);
        }
    }

    private OutputFile getOutputFile(String path, Map<String, String> properties) throws IOException {
        if (S3Utils.isS3Scheme(path)) {
            return S3ClientFactory.getS3OutputFile(path, properties);
        }
        return new LocalOutputFile(Paths.get(path, new String[0]));
    }

    @Override
    public void writeAll(List<List<?>> batch) {
        try {
            for (List<?> row : batch) {
                Group group = this.createGroup(row);
                this.writer.write((Object)group);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while writing to parquet file: " + e);
        }
    }

    private Group createGroup(List<?> values) {
        Group group = this.groupFactory.newGroup();
        for (int i = 0; i < this.schema.getColumns().size(); ++i) {
            ParquetGroupUtils.putValueToGroup(group, this.schema.getFieldName(i), values.get(i));
        }
        return group;
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

