/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload.parquet;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetGroupSchemaUtils {
    private static final String IGNITE_BINARY_TYPENAME = "[B";
    private static final Map<String, PrimitiveType.PrimitiveTypeName> primitiveTypeMap = new HashMap<String, PrimitiveType.PrimitiveTypeName>(){
        {
            this.put(Integer.class.getName(), PrimitiveType.PrimitiveTypeName.INT32);
            this.put(Long.class.getName(), PrimitiveType.PrimitiveTypeName.INT64);
            this.put(Double.class.getName(), PrimitiveType.PrimitiveTypeName.DOUBLE);
            this.put(Float.class.getName(), PrimitiveType.PrimitiveTypeName.FLOAT);
            this.put(Timestamp.class.getName(), PrimitiveType.PrimitiveTypeName.INT96);
            this.put(String.class.getName(), PrimitiveType.PrimitiveTypeName.BINARY);
            this.put(Date.class.getName(), PrimitiveType.PrimitiveTypeName.INT32);
            this.put(Boolean.class.getName(), PrimitiveType.PrimitiveTypeName.BOOLEAN);
            this.put(ParquetGroupSchemaUtils.IGNITE_BINARY_TYPENAME, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
            this.put(Short.class.getName(), PrimitiveType.PrimitiveTypeName.INT32);
        }
    };
    private static final Map<String, LogicalTypeAnnotation> logicalTypeMap = new HashMap<String, LogicalTypeAnnotation>(){
        {
            this.put(Date.class.getName(), LogicalTypeAnnotation.dateType());
            this.put(String.class.getName(), LogicalTypeAnnotation.stringType());
            this.put(ParquetGroupSchemaUtils.IGNITE_BINARY_TYPENAME, LogicalTypeAnnotation.uuidType());
        }
    };

    public static Type getParquetType(GridQueryFieldMetadata fieldMeta) {
        LogicalTypeAnnotation logicalTypeAnnotation;
        Type.Repetition repetition;
        if (fieldMeta.fieldTypeName().equals(IGNITE_BINARY_TYPENAME)) {
            return ParquetGroupSchemaUtils.handleBinaryType(fieldMeta);
        }
        Type.Repetition repetition2 = repetition = fieldMeta.nullability() == 0 ? Type.Repetition.REQUIRED : Type.Repetition.OPTIONAL;
        if (fieldMeta.fieldTypeName().equals(BigDecimal.class.getName())) {
            int precision = fieldMeta.precision() == 65535 ? 38 : fieldMeta.precision();
            int scale = fieldMeta.scale() == Short.MAX_VALUE ? 20 : fieldMeta.scale();
            logicalTypeAnnotation = LogicalTypeAnnotation.decimalType((int)scale, (int)precision);
        } else {
            logicalTypeAnnotation = logicalTypeMap.get(fieldMeta.fieldTypeName());
        }
        PrimitiveType.PrimitiveTypeName primitiveTypeName = primitiveTypeMap.getOrDefault(fieldMeta.fieldTypeName(), PrimitiveType.PrimitiveTypeName.BINARY);
        return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)primitiveTypeName, (Type.Repetition)repetition).as(logicalTypeAnnotation)).named(fieldMeta.fieldName());
    }

    private static Type handleBinaryType(GridQueryFieldMetadata fieldMeta) {
        Type.Repetition repetition = fieldMeta.nullability() == 0 ? Type.Repetition.REQUIRED : Type.Repetition.OPTIONAL;
        boolean isUUID = fieldMeta.precision() == 16;
        LogicalTypeAnnotation.UUIDLogicalTypeAnnotation logicalTypeAnnotation = isUUID ? LogicalTypeAnnotation.uuidType() : null;
        PrimitiveType.PrimitiveTypeName primitiveTypeName = isUUID ? PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY : PrimitiveType.PrimitiveTypeName.BINARY;
        int typeLength = isUUID ? 16 : 0;
        return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)primitiveTypeName, (Type.Repetition)repetition).length(typeLength)).as((LogicalTypeAnnotation)logicalTypeAnnotation)).named(fieldMeta.fieldName());
    }
}

