/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.util.Arrays;
import java.util.Collection;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.BulkLoadParquetAbstractTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BulkloadParquetColumnsCaseSensitivityTest
extends BulkLoadParquetAbstractTest {
    private static final String BULKLOAD_ALL_FIELDS = "parquet/all_fields_data.parquet";
    private static final String BULKLOAD_ALL_FIELDS_EXPECTED = "parquet/all_fields_data_expected.csv";
    @Parameterized.Parameter
    public String commaSeparatedColumns;

    @Parameterized.Parameters
    public static Collection<String> parameters() {
        return Arrays.asList("id,firstName,lastName,birthdate,registered,married,children,averageSalary", "ID,FIRSTNAME,LASTNAME,BIRTHDATE,REGISTERED,MARRIED,CHILDREN,AVERAGESALARY", "id,FIRSTNAME,lastName,BIRTHDATE,registered,MARRIED,children,AVERAGESALARY", "Id,FirstName,LastName,Birthdate,Registered,Married,Children,AverageSalary");
    }

    @Test
    public void importParquetCaseSensitivityTest() throws Exception {
        String tblDesc = "PersonExtended(" + this.commaSeparatedColumns + ")";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_ALL_FIELDS).into(tblDesc).toString());
        BulkloadParquetColumnsCaseSensitivityTest.assertEquals((int)10, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", BULKLOAD_ALL_FIELDS_EXPECTED);
    }
}

