/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.BulkLoadParquetAbstractTest;
import org.gridgain.bulkload.util.S3Utils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import software.amazon.awssdk.services.s3.S3Client;

public class BulkLoadS3ParquetTest
extends BulkLoadParquetAbstractTest {
    private static final String BULKLOAD_ALL_FIELDS = "parquet/all_fields_data.parquet";
    private static final String BULKLOAD_ALL_FIELDS_EXPECTED = "parquet/all_fields_data_expected.csv";
    private static Map<String, String> properties;
    private S3Client s3;
    private String bucketName;

    @Before
    public void setup() throws Exception {
        this.bucketName = System.getenv("s3.bucket-name");
        properties = new HashMap<String, String>();
        properties.put("s3.client-region", System.getenv("s3.client-region"));
        properties.put("s3.access-key-id", System.getenv("s3.access-key-id"));
        properties.put("s3.secret-access-key", System.getenv("s3.secret-access-key"));
        properties = Collections.unmodifiableMap(properties);
        this.s3 = S3Utils.s3client(properties);
    }

    @Test
    public void basicTest() throws Exception {
        this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_ALL_FIELDS).into(TBL).toString());
        String uri = String.format("s3://%s/%s", this.bucketName, BULKLOAD_ALL_FIELDS);
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from(TBL).into(String.format("'%s'", uri)).properties(properties).toString());
        BulkLoadS3ParquetTest.assertEquals((int)10, (int)updatesCnt);
        this.stmt.executeUpdate("DELETE FROM PersonExtended");
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from(String.format("'%s'", uri)).into(TBL).properties(properties).toString());
        BulkLoadS3ParquetTest.assertEquals((int)10, (int)updatesCnt);
        this.checkCacheContents("PersonExtended", BULKLOAD_ALL_FIELDS_EXPECTED);
    }

    @Test
    public void testFileExists() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().fromResource(BULKLOAD_ALL_FIELDS).into(TBL).toString());
        String uri = String.format("s3://%s/%s", this.bucketName, BULKLOAD_ALL_FIELDS);
        S3Utils.uploadFileToS3Bucket(this.s3, this.bucketName, BULKLOAD_ALL_FIELDS, Paths.get(BulkLoadS3ParquetTest.resolveAbsolutePath(BULKLOAD_ALL_FIELDS), new String[0]));
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy().from(TBL).into(String.format("'%s'", uri)).properties(properties).toString()), SQLException.class, (String)"Key already exist");
    }

    @After
    public void tearDown() {
        S3Utils.cleanS3Bucket(this.s3, this.bucketName, BULKLOAD_ALL_FIELDS);
    }
}

