/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.parquet.io.InputFile;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.gridgain.bulkload.ParquetFileReader;
import org.gridgain.bulkload.parquet.LocalInputFile;

public class BulkLoadParquetAbstractTest
extends BulkLoadAbstractTest {
    protected static final String TBL_NAME = "PersonExtended";
    protected static final List<String> TBL_COLUMNS = Arrays.asList("id", "firstName", "lastName", "birthdate", "registered", "married", "children", "averageSalary");
    protected static final String TBL = "PersonExtended(" + String.join((CharSequence)",", TBL_COLUMNS) + ")";
    protected static final DateTimeFormatter EXPECTED_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S");

    protected void checkCacheContents(String tblName, String expectedFilename, List<String> columns) throws Exception {
        String strLine;
        ResultSet rs = this.stmt.executeQuery("select " + String.join((CharSequence)",", columns) + " from " + tblName);
        HashMap<String, String[]> expectedData = new HashMap<String, String[]>();
        FileInputStream fstream = new FileInputStream(BulkLoadParquetAbstractTest.resolveAbsolutePath(expectedFilename));
        BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
        while ((strLine = br.readLine()) != null) {
            String[] splitted = strLine.split(",");
            expectedData.put(splitted[0], splitted);
        }
        int cnt = 0;
        while (rs.next()) {
            String[] currentRowExpectedData = (String[])expectedData.get(rs.getString(columns.get(0)));
            int csvColumnNum = 0;
            for (String column : columns) {
                String actual = this.getValueFromResultSet(rs, column);
                String expected = this.getExpectedValue(currentRowExpectedData[csvColumnNum], column);
                BulkLoadParquetAbstractTest.assertEquals((String)expected, (String)actual);
                ++csvColumnNum;
            }
            ++cnt;
        }
        BulkLoadParquetAbstractTest.assertEquals((int)expectedData.size(), (int)cnt);
    }

    private String getValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
        if (columnName.equals("bin")) {
            return new String(rs.getBytes(columnName));
        }
        return rs.getString(columnName);
    }

    protected String getExpectedValue(String value, String column) {
        if ("registered".equals(column)) {
            return this.convertDateTimeToLocal(value);
        }
        return value;
    }

    private String convertDateTimeToLocal(String datetime) {
        return LocalDateTime.parse(datetime, EXPECTED_DATE_FORMAT).atZone(ZoneId.of("UTC")).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime().format(EXPECTED_DATE_FORMAT);
    }

    protected void checkCacheContents(String tblName, List<String> columns, List<List<?>> expectedValues) throws Exception {
        ResultSet rs = this.stmt.executeQuery("select " + String.join((CharSequence)",", columns) + " from " + tblName + " order by _key");
        int cnt = 0;
        while (rs.next()) {
            List<?> currentRowExpectedData = expectedValues.get(cnt);
            int csvColumnNum = 0;
            for (String column : columns) {
                String expected = null;
                if (currentRowExpectedData.get(csvColumnNum) instanceof byte[]) {
                    expected = new String((byte[])currentRowExpectedData.get(csvColumnNum));
                } else if (currentRowExpectedData.get(csvColumnNum) != null) {
                    expected = currentRowExpectedData.get(csvColumnNum).toString();
                }
                BulkLoadParquetAbstractTest.assertEquals((String)expected, (String)this.getValueFromResultSet(rs, column));
                ++csvColumnNum;
            }
            ++cnt;
        }
        BulkLoadParquetAbstractTest.assertEquals((int)expectedValues.size(), (int)cnt);
    }

    protected List<List<?>> readValuesFromParquetFile(File file, List<String> cols) throws Exception {
        List result;
        try (ParquetFileReader reader = new ParquetFileReader((InputFile)new LocalInputFile(file.toPath()), cols);){
            result = reader.nextBatch(2048);
        }
        result.sort(Comparator.comparing(e -> Long.parseLong(e.get(0).toString())));
        return result;
    }

    protected List<List<?>> readValuesFromParquetFile(String path, List<String> cols) throws Exception {
        return this.readValuesFromParquetFile(Paths.get(path, new String[0]).toFile(), cols);
    }

    protected void checkCacheContents(String tblName, String expectedFilename) throws Exception {
        this.checkCacheContents(tblName, expectedFilename, TBL_COLUMNS);
    }

    @Override
    protected String getFormatDefault() {
        return "parquet";
    }

    @Override
    protected CacheConfiguration cacheConfig() {
        return this.nonBinCacheConfig("id");
    }
}

