/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.bulkload;

import java.sql.SQLException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.bulkload.AbstractCsvTest;
import org.gridgain.bulkload.BulkLoadAbstractTest;
import org.junit.Test;

public class BulkLoadCsvTest
extends AbstractCsvTest {
    private static final String TBL_NAME = "Person";
    public static final String TBL_COLS = " (_key, age, firstName, lastName)";
    private static final String TBL = "Person (_key, age, firstName, lastName)";
    private static final String BULKLOAD_CSV = "csv/bulkload.csv";
    private static final String BULKLOAD_QUOTED_CSV = "csv/bulkload_quoted.csv";
    private static final String BULKLOAD_QUOTED_EXPECTED_CSV = "csv/bulkload_quoted_expected.csv";
    private static final String BULKLOAD_PIPE_CSV = "csv/bulkload_pipe.csv";
    private static final String BULKLOAD_PIPE_EXPECTED_CSV = "csv/bulkload_pipe_expected.csv";
    private static final String BULKLOAD_UNMATCHED_1_CSV = "csv/bulkload_unmatched_1.csv";
    private static final String BULKLOAD_UNMATCHED_2_CSV = "csv/bulkload_unmatched_2.csv";
    private static final String BULKLOAD_EMPTY_CSV = "csv/bulkload_empty.csv";
    private static final String BULKLOAD_HEADERS_CSV = "csv/bulkload_headers.csv";
    private static final String BULKLOAD_HEADERS_CASE_CSV = "csv/bulkload_headers_case.csv";
    private static final String BULKLOAD_BINARY_FILE = "parquet/all_fields_data.parquet";
    private static final String BULKLOAD_SUBSET_1_EXPECTED_CSV = "csv/bulkload_subset_1_expected.csv";
    private static final String BULKLOAD_SUBSET_2_EXPECTED_CSV = "csv/bulkload_subset_2_expected.csv";

    @Override
    protected String getFormatDefault() {
        return "csv delimiter ','";
    }

    @Test
    public void testBasic() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_CSV).into(TBL).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_CSV);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).intoTemp().toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, this.temp);
    }

    @Test
    public void testQuoted() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_QUOTED_CSV).into(TBL).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_QUOTED_EXPECTED_CSV);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).intoTemp().toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, this.temp);
    }

    @Test
    public void testEmptyFile() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_EMPTY_CSV).into(TBL).toString());
        BulkLoadCsvTest.assertEquals((int)0, (int)updatesCnt);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).intoTemp().toString());
        BulkLoadCsvTest.assertEquals((int)0, (int)updatesCnt);
    }

    @Test
    public void testDelimiter_Pipe() throws Exception {
        String fmt = "csv delimiter '|'";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_PIPE_CSV).into(TBL).format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_PIPE_EXPECTED_CSV);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).intoTemp().format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, this.temp, "\\|");
    }

    @Test
    public void testSubquery() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_CSV).into(TBL).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_CSV);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from("(select _key, age, firstName, lastName from \"default\".Person)").intoTemp().toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, this.temp);
    }

    @Test
    public void testSubqueryShouldFail() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).into("(select _key, age, firstName, lastName from \"default\".Person)").toString()), SQLException.class, (String)"Unexpected locations COPY FROM");
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from("(select _key, () from table").intoTemp().toString()), SQLException.class, (String)"Unexpected end of command (expected: \"[query: parenthesis]\")");
    }

    @Test
    public void testSubsetWithoutHeaders() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_CSV).into("Person(_key)").toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_SUBSET_1_EXPECTED_CSV);
    }

    @Test
    public void testSubsetWithHeaders() throws Exception {
        String fmt = "csv header";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_HEADERS_CSV).into("Person(_key)").format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_SUBSET_1_EXPECTED_CSV);
    }

    @Test
    public void testSubsetWithHeadersIgnoreCase() throws Exception {
        String fmt = "csv header";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_HEADERS_CASE_CSV).into(TBL).format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_HEADERS_CASE_CSV, true);
    }

    @Test
    public void testChangeColumnsOrderWithoutHeaders() throws Exception {
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_CSV).into("Person(_key,age,lastname,firstname)").toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_SUBSET_2_EXPECTED_CSV);
    }

    @Test
    public void testChangeColumnsOrderWithHeaders() throws Exception {
        String fmt = "csv header";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_HEADERS_CSV).into("Person(_key,lastname,firstname,age)").format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_CSV);
    }

    @Test
    public void testUnmatched_1() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_UNMATCHED_1_CSV).into(TBL).toString()), SQLException.class, (String)"Unterminated quoted field");
    }

    @Test
    public void testUnmatched_2() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_UNMATCHED_2_CSV).into(TBL).toString()), SQLException.class, (String)"Unterminated quoted field");
    }

    @Test
    public void testHeader() throws Exception {
        String fmt = "csv header";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_HEADERS_CSV).into(TBL).format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_HEADERS_CSV, true);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).intoTemp().format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, this.temp, true);
    }

    @Test
    public void testHeaderWithDelimiter() throws Exception {
        String fmt = "csv delimiter ',' header";
        int updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_HEADERS_CSV).into(TBL).format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, BULKLOAD_HEADERS_CSV, true);
        updatesCnt = this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).from(TBL).intoTemp().format(fmt).toString());
        BulkLoadCsvTest.assertEquals((int)9, (int)updatesCnt);
        this.checkCacheContents(TBL_NAME, this.temp, true);
    }

    @Test
    public void testParseBinaryAsCsv() {
        GridTestUtils.assertThrows((IgniteLogger)this.log(), () -> this.stmt.executeUpdate(new BulkLoadAbstractTest.Copy(this).fromResource(BULKLOAD_BINARY_FILE).into(TBL).toString()), SQLException.class, (String)"Failed to read CSV file");
    }
}

